/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.util.Collection;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
public class ProtobufMetadataManagerDMROperationsIT {
    private static final String containerName = "clustered";
    @InfinispanResource(value="remote-query-1")
    protected RemoteInfinispanServer server;
    private ModelControllerClient controller;

    @Before
    public void setUp() throws Exception {
        this.controller = ModelControllerClient.Factory.create((String)this.server.getHotrodEndpoint().getInetAddress().getHostName(), (int)9990);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            if (this.controller != null) {
                this.controller.close();
            }
        }
        finally {
            RemoteCacheManagerFactory rcmFactory = new RemoteCacheManagerFactory();
            ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
            clientBuilder.addServer().host(this.server.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server.getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
            RemoteCacheManager remoteCacheManager = rcmFactory.createManager(clientBuilder);
            RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
            metadataCache.remove((Object)"test1.proto");
            metadataCache.remove((Object)"test1.proto.errors");
            metadataCache.remove((Object)"test2.proto");
            metadataCache.remove((Object)"test2.proto.errors");
            metadataCache.remove((Object)"test3.proto");
            metadataCache.remove((Object)"test3.proto.errors");
            rcmFactory.stopManagers();
        }
    }

    @Test
    public void testOperations() throws Exception {
        ModelNode op = this.getOperation("get-proto-schema-names");
        ModelNode result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = this.getOperation("unregister-proto-schemas");
        op.get("file-names").set((Collection)result.get("result").asList());
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = this.getOperation("get-proto-schema-names");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[]", (Object)result.get("result").asString());
        op = this.getOperation("get-proto-schemas-with-errors");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[]", (Object)result.get("result").asString());
        op = this.getOperation("register-proto-schemas");
        op.get("file-names").set(new ModelNode().add("test1.proto"));
        op.get("file-contents").set(new ModelNode().add("package test;"));
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = this.getOperation("get-proto-schema-names");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[\"test1.proto\"]", (Object)result.get("result").asString());
        op = this.getOperation("get-proto-schemas-with-errors");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[]", (Object)result.get("result").asString());
        op = this.getOperation("get-proto-schema");
        op.get("file-name").set("test1.proto");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"package test;", (Object)result.get("result").asString());
        op = this.getOperation("upload-proto-schemas");
        op.get("file-names").set(new ModelNode().add("test2.proto"));
        ModelNode urlList = new ModelNode().add(this.getClass().getResource("/sample_bank_account/bank.proto").toString());
        op.get("file-urls").set(urlList);
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = this.getOperation("get-proto-schema-names");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[\"test1.proto\",\"test2.proto\"]", (Object)result.get("result").asString());
        op = this.getOperation("get-proto-schemas-with-errors");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[]", (Object)result.get("result").asString());
        op = this.getOperation("register-proto-schemas");
        op.get("file-names").set(new ModelNode().add("test3.proto"));
        op.get("file-contents").set(new ModelNode().add("kabooom"));
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = this.getOperation("get-proto-schema-names");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[\"test1.proto\",\"test2.proto\",\"test3.proto\"]", (Object)result.get("result").asString());
        op = this.getOperation("get-proto-schema");
        op.get("file-name").set("test3.proto");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"kabooom", (Object)result.get("result").asString());
        op = this.getOperation("get-proto-schemas-with-errors");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[\"test3.proto\"]", (Object)result.get("result").asString());
        op = this.getOperation("get-proto-schema-errors");
        op.get("file-name").set("test3.proto");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"java.lang.IllegalStateException: Syntax error in test3.proto at 1:8: unexpected label: kabooom", (Object)result.get("result").asString());
        op = this.getOperation("unregister-proto-schemas");
        op.get("file-names").set(new ModelNode().add("test3.proto"));
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = this.getOperation("get-proto-schema");
        op.get("file-name").set("test3.proto");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"failed", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"DGISPN0118: Failed to invoke operation: File does not exist : test3.proto", (Object)result.get("failure-description").asString());
        op = this.getOperation("get-proto-schema-errors");
        op.get("file-name").set("test3.proto");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"failed", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"DGISPN0118: Failed to invoke operation: File does not exist : test3.proto", (Object)result.get("failure-description").asString());
        op = this.getOperation("get-proto-schemas-with-errors");
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"[]", (Object)result.get("result").asString());
        op = this.getOperation("unregister-proto-schemas");
        op.get("file-names").set(new ModelNode().add("test1.proto").add("test2.proto"));
        result = this.controller.execute(op);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
    }

    private ModelNode getOperation(String operationName) {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datagrid-infinispan")}).append("cache-container", containerName);
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        op.get("address").set(address.toModelNode());
        return op;
    }
}

