/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.io.IOException;
import java.util.Arrays;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.dsl.Query;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="remote-query-2")})
public class RemoteQueryDescriptorIT {
    @InfinispanResource(value="remote-query-1")
    protected RemoteInfinispanServer server1;
    @InfinispanResource(value="remote-query-2")
    protected RemoteInfinispanServer server2;
    public static final String MBEAN = "jboss.datagrid-infinispan:type=RemoteQuery,name=\"clustered\",component=ProtobufMetadataManager";

    @Test
    public void testDescriptorPropagation() throws Exception {
        this.registerProtoOnServer1();
        this.assertRegisteredOn(this.server1);
        this.assertRegisteredOn(this.server2);
        this.populateCache();
        Assert.assertEquals((long)1L, (long)this.queryResultsIn(this.server1));
        Assert.assertEquals((long)1L, (long)this.queryResultsIn(this.server2));
    }

    private void registerProtoOnServer1() throws Exception {
        String[] fileNames = new String[]{"sample_bank_account/bank.proto"};
        String[] fileContents = new String[]{Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader())};
        this.invoke(this.getJmxConnection(this.server1), "registerProtofiles", fileNames, fileContents);
        Object errors = this.getAttribute(this.getJmxConnection(this.server1), "filesWithErrors");
        Assert.assertNull((Object)errors);
        Object protofileNames = this.getAttribute(this.getJmxConnection(this.server1), "protofileNames");
        Assert.assertTrue((boolean)(protofileNames instanceof String[]));
        Assert.assertTrue((boolean)Arrays.asList((String[])protofileNames).contains("sample_bank_account/bank.proto"));
    }

    private void assertRegisteredOn(RemoteInfinispanServer server) throws Exception {
        Object proto = this.invoke(this.getJmxConnection(server), "getProtofile", "sample_bank_account/bank.proto");
        Assert.assertTrue((boolean)proto.toString().contains("message User"));
    }

    private Object getAttribute(MBeanServerConnectionProvider provider, String attrName) throws Exception {
        return provider.getConnection().getAttribute(new ObjectName(MBEAN), attrName);
    }

    private Object invoke(MBeanServerConnectionProvider provider, String opName, Object ... params) throws Exception {
        String[] types = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass().getName();
        }
        return ITestUtils.invokeOperation(provider, MBEAN, opName, params, types);
    }

    private MBeanServerConnectionProvider getJmxConnection(RemoteInfinispanServer server) {
        return new MBeanServerConnectionProvider(server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
    }

    private int queryResultsIn(RemoteInfinispanServer server) throws IOException {
        ConfigurationBuilder configurationBuilder = this.configurationBuilder(server);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManagerFactory().createManager(configurationBuilder);
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager));
        RemoteCache remoteCache = remoteCacheManager.getCache("repl_descriptor");
        Query query = Search.getQueryFactory((RemoteCache)remoteCache).from(User.class).build();
        return query.list().size();
    }

    private ConfigurationBuilder configurationBuilder(RemoteInfinispanServer server) {
        return new ConfigurationBuilder().addServer().host(server.getHotrodEndpoint().getInetAddress().getHostName()).port(server.getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    private void populateCache() throws IOException {
        ConfigurationBuilder clientBuilder = this.configurationBuilder(this.server1);
        User user = new User();
        user.setId(0);
        user.setName("user1");
        user.setSurname("surname");
        RemoteCacheManager manager = new RemoteCacheManagerFactory().createManager(clientBuilder);
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)manager));
        RemoteCache cache = manager.getCache("repl_descriptor");
        cache.put((Object)1, (Object)user);
    }
}

