/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.query.RemoteQueryBaseIT;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
public class RemoteQueryKeyRestInteropIT
extends RemoteQueryBaseIT {
    @InfinispanResource(value="remote-query-1")
    protected RemoteInfinispanServer server;
    private final CloseableHttpClient restClient = HttpClients.createDefault();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RemoteQueryKeyRestInteropIT() {
        super("clustered", "disttestcache");
    }

    @Override
    protected RemoteInfinispanServer getServer() {
        return this.server;
    }

    @Test
    public void testHotRodRestInterop() throws Exception {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        HttpGet get = new HttpGet("http://localhost:8080/rest/disttestcache/1");
        get.addHeader("Accept", "application/json");
        get.addHeader("Key-Content-Type", "application/x-java-object; type=java.lang.Integer");
        CloseableHttpResponse getResponse = this.restClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)getResponse.getStatusLine().getStatusCode());
        JsonNode node = this.objectMapper.readTree(EntityUtils.toString((HttpEntity)getResponse.getEntity()));
        Assert.assertEquals((Object)"sample_bank_account.User", (Object)node.get("_type").asText());
        Assert.assertEquals((long)1L, (long)node.get("id").asInt());
        Assert.assertEquals((Object)"John", (Object)node.get("name").asText());
        HttpPost httpPost = new HttpPost("http://localhost:8080/rest/disttestcache/2");
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.addHeader("Key-Content-Type", "application/x-java-object; type=java.lang.Integer");
        ObjectNode user2 = this.objectMapper.createObjectNode();
        user2.put("_type", "sample_bank_account.User");
        user2.put("id", 2);
        user2.put("name", "Donald");
        user2.put("surname", "Duck");
        httpPost.setEntity((HttpEntity)new StringEntity(user2.toString()));
        CloseableHttpResponse response = this.restClient.execute((HttpUriRequest)httpPost);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        User user = (User)this.remoteCache.get((Object)2);
        Assert.assertEquals((long)2L, (long)user.getId());
        Assert.assertEquals((Object)"Donald", (Object)user.getName());
        Assert.assertEquals((Object)"Duck", (Object)user.getSurname());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.restClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("John");
        user.setSurname("Doe");
        user.setGender(User.Gender.MALE);
        return user;
    }
}

