/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Transaction;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.query.TestSearchMappingFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Queries.class})
public class RemoteQueryStringIT {
    private static final String TEST_PROGRAMMATIC_SEARCH_MAPPING_PROVIDER_JAR = "test-ProgrammaticSearchMappingProvider.jar";
    private static File deployment;
    private static RemoteCacheManager remoteCacheManager;
    @InfinispanResource(value="query-programmatic-search-mapping-provider")
    protected RemoteInfinispanServer server;

    @BeforeClass
    public static void before() {
        JavaArchive programmaticSearchMappingProviderArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(TestSearchMappingFactory.class)).addClass(TestSearchMappingFactory.MySearchableEntity.class)).add((Asset)new StringAsset("Dependencies: org.infinispan.query, org.hibernate.search.engine"), "META-INF/MANIFEST.MF")).addAsServiceProvider(ProgrammaticSearchMappingProvider.class, new Class[0]);
        deployment = new File(System.getProperty("server1.dist"), "/standalone/deployments/test-ProgrammaticSearchMappingProvider.jar");
        ((ZipExporter)programmaticSearchMappingProviderArchive.as(ZipExporter.class)).exportTo(deployment, true);
    }

    @AfterClass
    public static void after() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
        if (deployment != null) {
            deployment.delete();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="query-programmatic-search-mapping-provider")})
    public void testFullTextTermRightOperandAnalyzed() throws Exception {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.server.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server.getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager));
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.clear();
        remoteCache.put((Object)1, (Object)this.createTransaction1());
        QueryFactory qf = Search.getQueryFactory((RemoteCache)remoteCache);
        Query q = qf.create("from sample_bank_account.Transaction where longDescription:'RENT'");
        List list = q.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Transaction.class, ((Transaction)list.get(0)).getClass());
        this.assertTransaction1((Transaction)list.get(0));
    }

    private Transaction createTransaction1() {
        Transaction tx = new Transaction();
        tx.setId(1);
        tx.setAccountId(777);
        tx.setAmount(500.0);
        tx.setDate(new Date(1L));
        tx.setDescription("February rent");
        tx.setLongDescription("February rent");
        tx.setNotes("card was not present");
        return tx;
    }

    private void assertTransaction1(Transaction tx) {
        Assert.assertNotNull((Object)tx);
        Assert.assertEquals((long)1L, (long)tx.getId());
        Assert.assertEquals((long)777L, (long)tx.getAccountId());
        Assert.assertEquals((double)500.0, (double)tx.getAmount(), (double)0.0);
        Assert.assertEquals((Object)new Date(1L), (Object)tx.getDate());
        Assert.assertEquals((Object)"February rent", (Object)tx.getDescription());
        Assert.assertEquals((Object)"February rent", (Object)tx.getLongDescription());
        Assert.assertEquals((Object)"card was not present", (Object)tx.getNotes());
    }
}

