/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
public class RemoteQueryWithProtostreamAnnotationsIT {
    private static final String cacheName = "localtestcache";
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, AnnotatedUser> remoteCache;
    private RemoteCacheManagerFactory rcmFactory;
    @InfinispanResource(value="remote-query-1")
    protected RemoteInfinispanServer server;

    @Before
    public void setUp() throws Exception {
        this.rcmFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.server.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server.getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = this.rcmFactory.createManager(clientBuilder);
        this.remoteCache = this.remoteCacheManager.getCache(cacheName);
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("test.proto").addClass(AnnotatedUser.class).build(serializationContext);
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"test.proto", (Object)protoFile);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
    }

    @After
    public void tearDown() {
        if (this.remoteCache != null) {
            this.remoteCache.clear();
        }
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    @Test
    public void testAttributeQuery() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        AnnotatedUser fromCache = (AnnotatedUser)this.remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(AnnotatedUser.class).having("name").eq((Object)"Tom").build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(AnnotatedUser.class, ((AnnotatedUser)list.get(0)).getClass());
        this.assertUser1((AnnotatedUser)list.get(0));
        query = qf.from(AnnotatedUser.class).having("address.postCode").eq((Object)"Xyz").build();
        list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(AnnotatedUser.class, ((AnnotatedUser)list.get(0)).getClass());
        this.assertUser2((AnnotatedUser)list.get(0));
    }

    private AnnotatedUser createUser1() {
        AnnotatedUser user = new AnnotatedUser();
        user.setId(1);
        user.setName("Tom");
        return user;
    }

    private AnnotatedUser createUser2() {
        AnnotatedAddress address = new AnnotatedAddress();
        address.setStreet("North street");
        address.setPostCode("Xyz");
        AnnotatedUser user = new AnnotatedUser();
        user.setId(2);
        user.setName("Adrian");
        user.setAddress(address);
        return user;
    }

    private void assertUser1(AnnotatedUser user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
    }

    private void assertUser2(AnnotatedUser user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)2L, (long)user.getId());
        Assert.assertEquals((Object)"Adrian", (Object)user.getName());
        Assert.assertNotNull((Object)user.getAddress());
        Assert.assertEquals((Object)"North street", (Object)user.getAddress().getStreet());
        Assert.assertEquals((Object)"Xyz", (Object)user.getAddress().getPostCode());
    }

    @ProtoMessage(name="Address")
    public static class AnnotatedAddress {
        private String street;
        private String postCode;

        @ProtoField(number=10)
        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        @ProtoField(number=20)
        public String getPostCode() {
            return this.postCode;
        }

        public void setPostCode(String postCode) {
            this.postCode = postCode;
        }

        public String toString() {
            return "AnnotatedAddress{street='" + this.street + '\'' + ", postCode='" + this.postCode + '\'' + '}';
        }
    }

    @ProtoDoc(value="@Indexed")
    @ProtoMessage(name="User")
    public static class AnnotatedUser {
        private int id;
        private String name;
        private AnnotatedAddress address;

        @ProtoDoc(value="@IndexedField(index = false, store = false)")
        @ProtoField(number=1, required=true)
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @ProtoDoc(value="@IndexedField")
        @ProtoField(number=2)
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ProtoDoc(value="@IndexedField")
        @ProtoField(number=3)
        public AnnotatedAddress getAddress() {
            return this.address;
        }

        public void setAddress(AnnotatedAddress address) {
            this.address = address;
        }

        public String toString() {
            return "AnnotatedUser{id=" + this.id + ", name='" + this.name + '\'' + ", address=" + this.address + '}';
        }
    }
}

