/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.rollingupgrades;

import javax.management.ObjectName;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.category.RollingUpgradesDist;
import org.infinispan.server.test.rollingupgrades.AbstractHotRodRollingUpgradesIT;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RollingUpgradesDist.class})
public class HotRodRollingUpgradesDistIT
extends AbstractHotRodRollingUpgradesIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHotRodRollingUpgradesDiffVersionsDist() throws Exception {
        int managementPortServer1 = 9990;
        int managementPortServer2 = 10090;
        try {
            if (!Boolean.parseBoolean(System.getProperty("start.jboss.as.manually"))) {
                this.controller.start("hotrod-rolling-upgrade-3-old-dist");
                this.controller.start("hotrod-rolling-upgrade-4-old-dist");
            }
            ConfigurationBuilder builder3 = new ConfigurationBuilder();
            builder3.addServer().host("127.0.0.1").port(11422).version(ProtocolVersion.PROTOCOL_VERSION_25);
            RemoteCacheManager rcm3 = new RemoteCacheManager(builder3.build());
            RemoteCache c3 = rcm3.getCache("default");
            ConfigurationBuilder builder4 = new ConfigurationBuilder();
            builder4.addServer().host("127.0.0.1").port(11522).version(ProtocolVersion.PROTOCOL_VERSION_25);
            RemoteCacheManager rcm4 = new RemoteCacheManager(builder4.build());
            RemoteCache c4 = rcm4.getCache("default");
            c3.put((Object)"key1", (Object)"value1");
            Assert.assertEquals((Object)"value1", (Object)c3.get((Object)"key1"));
            c4.put((Object)"keyx1", (Object)"valuex1");
            Assert.assertEquals((Object)"valuex1", (Object)c4.get((Object)"keyx1"));
            for (int i = 0; i < 50; ++i) {
                c3.put((Object)("keyLoad" + i), (Object)("valueLoad" + i));
                c4.put((Object)("keyLoadx" + i), (Object)("valueLoadx" + i));
            }
            this.controller.start("hotrod-rolling-upgrade-1-dist");
            this.controller.start("hotrod-rolling-upgrade-2-dist");
            RemoteInfinispanMBeans s1 = this.createRemotes("hotrod-rolling-upgrade-1-dist", "clustered-new", "default");
            RemoteCache<Object, Object> c1 = this.createCache(s1);
            RemoteInfinispanMBeans s2 = this.createRemotes("hotrod-rolling-upgrade-2-dist", "clustered-new", "default");
            RemoteCache<Object, Object> c2 = this.createCache(s2);
            Assert.assertEquals((String)"Can't access entries stored in source node (target's RemoteCacheStore).", (Object)"value1", (Object)c1.get((Object)"key1"));
            Assert.assertEquals((String)"Can't access entries stored in source node (target's RemoteCacheStore).", (Object)"valuex1", (Object)c1.get((Object)"keyx1"));
            Assert.assertEquals((String)"Can't access entries stored in source node (target's RemoteCacheStore).", (Object)"value1", (Object)c2.get((Object)"key1"));
            Assert.assertEquals((String)"Can't access entries stored in source node (target's RemoteCacheStore).", (Object)"valuex1", (Object)c2.get((Object)"keyx1"));
            MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            MBeanServerConnectionProvider provider2 = new MBeanServerConnectionProvider(s2.server.getHotrodEndpoint().getInetAddress().getHostName(), 10090);
            ObjectName rollManTarget = new ObjectName("jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered-new\",component=RollingUpgradeManager");
            this.invokeOperation(provider1, rollManTarget.toString(), "synchronizeData", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
            this.invokeOperation(provider1, rollManTarget.toString(), "disconnectSource", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
            this.invokeOperation(provider2, rollManTarget.toString(), "disconnectSource", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
            c3.put((Object)"disconnected", (Object)"source");
            c4.put((Object)"disconnectedx", (Object)"sourcex");
            Assert.assertEquals((String)"Can't obtain value from cache3 (source node).", (Object)"source", (Object)c3.get((Object)"disconnected"));
            Assert.assertEquals((String)"Can't obtain value from cache4 (source node).", (Object)"source", (Object)c4.get((Object)"disconnected"));
            Assert.assertEquals((String)"Can't obtain value from cache3 (source node).", (Object)"sourcex", (Object)c3.get((Object)"disconnectedx"));
            Assert.assertEquals((String)"Can't obtain value from cache4 (source node).", (Object)"sourcex", (Object)c4.get((Object)"disconnectedx"));
            Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c1.get((Object)"disconnected"));
            Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c2.get((Object)"disconnected"));
            Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c1.get((Object)"disconnectedx"));
            Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c2.get((Object)"disconnectedx"));
            Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)"value1", (Object)c1.get((Object)"key1"));
            for (int i = 0; i < 50; ++i) {
                Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)("valueLoad" + i), (Object)c1.get((Object)("keyLoad" + i)));
                Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)("valueLoadx" + i), (Object)c1.get((Object)("keyLoadx" + i)));
            }
        }
        finally {
            if (this.controller.isStarted("hotrod-rolling-upgrade-1-dist")) {
                this.controller.stop("hotrod-rolling-upgrade-1-dist");
            }
            if (this.controller.isStarted("hotrod-rolling-upgrade-2-dist")) {
                this.controller.stop("hotrod-rolling-upgrade-2-dist");
            }
            if (this.controller.isStarted("hotrod-rolling-upgrade-3-old-dist")) {
                this.controller.stop("hotrod-rolling-upgrade-3-old-dist");
            }
            if (this.controller.isStarted("hotrod-rolling-upgrade-4-old-dist")) {
                this.controller.stop("hotrod-rolling-upgrade-4-old-dist");
            }
        }
    }
}

