/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.rollingupgrades;

import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.category.RollingUpgradesDist;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Ignore(value="Disabled until ISPN-7617 is fixed")
@RunWith(value=Arquillian.class)
@Category(value={RollingUpgradesDist.class})
public class RestRollingUpgradesDistIT {
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    static final String DEFAULT_CACHE_NAME = "default";
    static final int PORT_OFFSET = 100;
    static final int PORT_OFFSET_200 = 200;
    static final int PORT_OFFSET_300 = 300;
    @ArquillianResource
    ContainerController controller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestRollingUpgradesDiffVersionsDist() throws Exception {
        int managementPortServer1 = 9990;
        int managementPortServer2 = 10090;
        RESTHelper rest = new RESTHelper();
        if (!Boolean.parseBoolean(System.getProperty("start.jboss.as.manually"))) {
            this.controller.start("rest-rolling-upgrade-3-old-dist");
            this.controller.start("rest-rolling-upgrade-4-old-dist");
        }
        try {
            rest.addServer("127.0.0.1", "/rest");
            rest.addServer("127.0.0.1", "/rest");
            rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 200), "data", "text/html");
            rest.get(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 200), "data");
            rest.post(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "key1x", 300), "datax", "text/html");
            rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "key1x", 300), "datax");
            for (int i = 0; i < 50; ++i) {
                rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "keyLoad" + i, 200), "valueLoad" + i, "text/html");
                rest.post(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "keyLoadx" + i, 300), "valueLoadx" + i, "text/html");
            }
            this.controller.start("rest-rolling-upgrade-1-dist");
            this.controller.start("rest-rolling-upgrade-2-dist");
            RemoteInfinispanMBeans s1 = this.createRemotes("rest-rolling-upgrade-1-dist", "clustered-new", DEFAULT_CACHE_NAME);
            rest.addServer(s1.server.getRESTEndpoint().getInetAddress().getHostName(), s1.server.getRESTEndpoint().getContextPath());
            RemoteInfinispanMBeans s2 = this.createRemotes("rest-rolling-upgrade-2-dist", "clustered-new", DEFAULT_CACHE_NAME);
            rest.addServer(s2.server.getRESTEndpoint().getInetAddress().getHostName(), s2.server.getRESTEndpoint().getContextPath());
            rest.get(rest.fullPathKey(2, DEFAULT_CACHE_NAME, "key1", 0), "data");
            rest.get(rest.fullPathKey(2, DEFAULT_CACHE_NAME, "key1x", 0), "datax");
            rest.get(rest.fullPathKey(3, DEFAULT_CACHE_NAME, "key1", 100), "data");
            rest.get(rest.fullPathKey(3, DEFAULT_CACHE_NAME, "key1x", 100), "datax");
            MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getRESTEndpoint().getInetAddress().getHostName(), 9990);
            ObjectName rollMan1 = new ObjectName("jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered-new\",component=RollingUpgradeManager");
            this.invokeOperation(provider1, rollMan1.toString(), "synchronizeData", new Object[]{"rest"}, new String[]{"java.lang.String"});
            this.invokeOperation(provider1, rollMan1.toString(), "disconnectSource", new Object[]{"rest"}, new String[]{"java.lang.String"});
            this.invokeOperation(new MBeanServerConnectionProvider(s2.server.getRESTEndpoint().getInetAddress().getHostName(), 10090), rollMan1.toString(), "disconnectSource", new Object[]{"rest"}, new String[]{"java.lang.String"});
            rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "disconnected", 200), "source", "text/html");
            rest.post(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "disconnectedx", 300), "sourcex", "text/html");
            rest.get(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "disconnected", 200), "source");
            rest.get(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "disconnectedx", 200), "sourcex");
            rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "disconnected", 300), "source");
            rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "disconnectedx", 300), "sourcex");
            rest.get(rest.fullPathKey(2, DEFAULT_CACHE_NAME, "disconnected", 0), 404);
            rest.get(rest.fullPathKey(3, DEFAULT_CACHE_NAME, "disconnected", 100), 404);
            rest.get(rest.fullPathKey(2, DEFAULT_CACHE_NAME, "disconnectedx", 0), 404);
            rest.get(rest.fullPathKey(3, DEFAULT_CACHE_NAME, "disconnectedx", 100), 404);
            rest.get(rest.fullPathKey(2, DEFAULT_CACHE_NAME, "key1", 0), "data");
            for (int i = 0; i < 50; ++i) {
                rest.get(rest.fullPathKey(2, DEFAULT_CACHE_NAME, "keyLoad" + i, 0), "valueLoad" + i);
                rest.get(rest.fullPathKey(2, DEFAULT_CACHE_NAME, "keyLoadx" + i, 0), "valueLoadx" + i);
            }
        }
        finally {
            if (this.controller.isStarted("rest-rolling-upgrade-1-dist")) {
                this.controller.stop("rest-rolling-upgrade-1-dist");
            }
            if (this.controller.isStarted("rest-rolling-upgrade-2-dist")) {
                this.controller.stop("rest-rolling-upgrade-2-dist");
            }
            if (this.controller.isStarted("rest-rolling-upgrade-3-old-dist")) {
                this.controller.stop("rest-rolling-upgrade-3-old-dist");
            }
            if (this.controller.isStarted("rest-rolling-upgrade-4-old-dist")) {
                this.controller.stop("rest-rolling-upgrade-4-old-dist");
            }
        }
    }

    protected RemoteInfinispanMBeans createRemotes(String serverName, String managerName, String cacheName) {
        return RemoteInfinispanMBeans.create(this.serverManager, serverName, cacheName, managerName);
    }

    private Object invokeOperation(MBeanServerConnectionProvider provider, String mbean, String operationName, Object[] params, String[] signature) throws Exception {
        return provider.getConnection().invoke(new ObjectName(mbean), operationName, params, signature);
    }
}

