/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.security.cache;

import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.hotrod.security.HotRodAuthzOperationTests;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuthClustered-2")})
public class ClusteredCacheAuthMd5IT {
    private static final String SASL_MECH = "DIGEST-MD5";
    private static final String ARQ_NODE_1_ID = "hotrodAuthClustered";
    @ArquillianResource
    public ContainerController controller;
    @InfinispanResource(value="hotrodAuthClustered")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="hotrodAuthClustered-2")
    RemoteInfinispanServer server2;
    private static Map<String, RemoteCacheManager> rcms;
    private static boolean isInitialized;

    public void initRCMs() {
        this.controller.start(ARQ_NODE_1_ID);
        SecurityConfigurationHelper cb = new SecurityConfigurationHelper(SASL_MECH).forIspnServer(this.server1).withServerName("node0");
        rcms = new HashMap<String, RemoteCacheManager>();
        rcms.put("admin", new RemoteCacheManager(cb.forCredentials("admin", "strongPassword").build(), true));
        rcms.put("writer", new RemoteCacheManager(cb.forCredentials("writer", "somePassword").build(), true));
        rcms.put("reader", new RemoteCacheManager(cb.forCredentials("reader", "password").build(), true));
        rcms.put("supervisor", new RemoteCacheManager(cb.forCredentials("supervisor", "lessStrongPassword").build(), true));
        this.controller.stop(ARQ_NODE_1_ID);
        isInitialized = true;
    }

    @AfterClass
    public static void release() {
        for (String rcmKey : rcms.keySet()) {
            RemoteCacheManager rcm = rcms.get(rcmKey);
            if (rcm == null) continue;
            rcm.stop();
        }
    }

    private synchronized RemoteCache<String, String> getRemoteCacheFor(String login) {
        if (!isInitialized) {
            this.initRCMs();
        }
        return rcms.get(login).getCache("testcache");
    }

    @Test
    public void testAdmin() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("admin");
        HotRodAuthzOperationTests.testPutGet(cache);
        HotRodAuthzOperationTests.testSize(cache);
    }

    @Test
    public void testReaderRead() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("reader");
        HotRodAuthzOperationTests.testGetNonExistent(cache);
    }

    @Test(expected=HotRodClientException.class)
    public void testReaderWrite() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("reader");
        HotRodAuthzOperationTests.testPut(cache);
    }

    @Test
    public void testWriterWrite() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("writer");
        HotRodAuthzOperationTests.testPut(cache);
    }

    @Test(expected=HotRodClientException.class)
    public void testWriterWriteRead() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("writer");
        HotRodAuthzOperationTests.testPutGet(cache);
    }

    @Test
    public void testSupervisorWriteRead() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("supervisor");
        HotRodAuthzOperationTests.testPutGet(cache);
        HotRodAuthzOperationTests.testSize(cache);
    }

    static {
        isInitialized = false;
    }
}

