/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.security.jgroups.sasl;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.test.integration.security.utils.ApacheDsKrbLdap;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
public class SaslAuthIT {
    @InfinispanResource
    RemoteInfinispanServers servers;
    @ArquillianResource
    ContainerController controller;
    final String COORDINATOR_NODE_MD5 = "clustered-sasl-md5-1";
    final String JOINING_NODE_MD5 = "clustered-sasl-md5-2";
    final String ANOTHER_JOINING_NODE_MD5 = "another-clustered-sasl-md5-2";
    final String MECH_MD5 = "DIGEST-MD5";
    final String COORDINATOR_NODE_KRB = "clustered-sasl-krb-1";
    final String JOINING_NODE_KRB = "clustered-sasl-krb-2";
    final String MECH_KRB = "GSSAPI";
    final String SASL_MBEAN = "jgroups:type=protocol,cluster=\"cluster\",protocol=SASL";
    private static ApacheDsKrbLdap krbLdapServer;

    @BeforeClass
    public static void ldapSetup() throws Exception {
        krbLdapServer = new ApacheDsKrbLdap("localhost");
        krbLdapServer.start();
    }

    @AfterClass
    public static void ldapTearDown() throws Exception {
        krbLdapServer.stop();
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-sasl-md5-1")})
    public void testSaslMD5() throws Exception {
        this.saslTest("clustered-sasl-md5-1", "clustered-sasl-md5-2", "DIGEST-MD5");
    }

    @Ignore
    @WithRunningServer(value={@RunningServer(name="clustered-sasl-krb-1")})
    public void testSaslKrb() throws Exception {
        this.saslTest("clustered-sasl-krb-1", "clustered-sasl-krb-2", "GSSAPI");
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-sasl-md5-1")})
    public void testNodeAuthorization() throws Exception {
        this.authorizationTest("clustered-sasl-md5-1", "another-clustered-sasl-md5-2", "DIGEST-MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saslTest(String coordinatorNode, String joiningNode, String mech) throws Exception {
        try {
            this.controller.start(joiningNode);
            RemoteInfinispanMBeans coordinator = RemoteInfinispanMBeans.create(this.servers, coordinatorNode, "memcachedCache", "clustered");
            RemoteInfinispanMBeans friend = RemoteInfinispanMBeans.create(this.servers, joiningNode, "memcachedCache", "clustered");
            MBeanServerConnectionProvider providerCoordinator = new MBeanServerConnectionProvider(coordinator.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            MBeanServerConnectionProvider providerFriend = new MBeanServerConnectionProvider(friend.server.getHotrodEndpoint().getInetAddress().getHostName(), 10090);
            MemcachedClient mcCoordinator = new MemcachedClient(coordinator.server.getMemcachedEndpoint().getInetAddress().getHostName(), coordinator.server.getMemcachedEndpoint().getPort());
            MemcachedClient mcFriend = new MemcachedClient(friend.server.getMemcachedEndpoint().getInetAddress().getHostName(), friend.server.getMemcachedEndpoint().getPort());
            Assert.assertEquals((long)2L, (long)coordinator.manager.getClusterSize());
            Assert.assertEquals((long)2L, (long)friend.manager.getClusterSize());
            Assert.assertEquals((Object)mech, (Object)ITestUtils.getAttribute(providerCoordinator, "jgroups:type=protocol,cluster=\"cluster\",protocol=SASL", "mech"));
            Assert.assertEquals((Object)mech, (Object)ITestUtils.getAttribute(providerFriend, "jgroups:type=protocol,cluster=\"cluster\",protocol=SASL", "mech"));
            mcFriend.set("key1", "value1");
            Assert.assertEquals((String)"Could not read replicated pair key1/value1", (Object)"value1", (Object)mcCoordinator.get("key1"));
        }
        finally {
            this.controller.stop(joiningNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authorizationTest(String coordinatorNode, String joiningNode, String mech) throws Exception {
        try {
            this.controller.start(joiningNode);
            RemoteInfinispanMBeans coordinator = RemoteInfinispanMBeans.create(this.servers, coordinatorNode, "memcachedCache", "clustered");
            Assert.assertEquals((long)1L, (long)coordinator.manager.getClusterSize());
        }
        finally {
            this.controller.stop(joiningNode);
        }
    }
}

