/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.HotRodClusteredDomain;
import org.infinispan.server.test.category.Task;
import org.infinispan.server.test.task.AbstractDistributedServerTaskIT;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.ManagementClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodClusteredDomain.class, Task.class})
public class DistributedServerTaskDomainIT
extends AbstractDistributedServerTaskIT {
    @InfinispanResource(value="master:server-one", jmxPort=4447)
    RemoteInfinispanServer server1;
    @InfinispanResource(value="master:server-two", jmxPort=4597)
    RemoteInfinispanServer server2;
    private static final String CUSTOM_TEMPLATE_NAME = "testConf";
    private static final String CUSTOM_TX_TEMPLATE_NAME = "testConfTx";

    @Deployment(testable=false, name="custom-distributed-task")
    @TargetsContainer(value="cluster")
    public static Archive<?> deploy() {
        JavaArchive jar = DistributedServerTaskDomainIT.createJavaArchive();
        jar.addAsResource(new File("/stream_serverTask.js"));
        jar.addAsManifestResource("MANIFEST.MF");
        return jar;
    }

    @Override
    protected List<RemoteInfinispanServer> getServers() {
        ArrayList<RemoteInfinispanServer> servers = new ArrayList<RemoteInfinispanServer>();
        servers.add(this.server1);
        servers.add(this.server2);
        return Collections.unmodifiableList(servers);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        client.enableJmx();
        HashMap<String, String> txAttrs = new HashMap<String, String>();
        txAttrs.put("mode", "NON_XA");
        txAttrs.put("locking", "PESSIMISTIC");
        if (ITestUtils.isDistributedMode()) {
            client.addDistributedCacheConfiguration(CUSTOM_TEMPLATE_NAME, "clustered");
            client.addDistributedCache("customTaskRepl", "clustered", CUSTOM_TEMPLATE_NAME);
            client.enableCompatibilityForDistConfiguration(CUSTOM_TEMPLATE_NAME, "clustered");
            client.addDistributedCacheConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered");
            client.enableTransactionForDistConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered", txAttrs);
            client.enableCompatibilityForDistConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered");
            client.addDistributedCache("customTaskReplTx", "clustered", CUSTOM_TX_TEMPLATE_NAME);
        } else if (ITestUtils.isReplicatedMode()) {
            client.addReplicatedCacheConfiguration(CUSTOM_TEMPLATE_NAME, "clustered");
            client.enableCompatibilityForReplConfiguration(CUSTOM_TEMPLATE_NAME, "clustered");
            client.addReplicatedCache("customTaskRepl", "clustered", CUSTOM_TEMPLATE_NAME);
            client.addReplicatedCacheConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered");
            client.enableTransactionForReplConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered", txAttrs);
            client.enableCompatibilityForReplConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered");
            client.addReplicatedCache("customTaskReplTx", "clustered", CUSTOM_TX_TEMPLATE_NAME);
        }
        client.reloadServer();
        expectedServerList = Arrays.asList("master:server-two", "master:server-one");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        if (ITestUtils.isDistributedMode()) {
            client.removeDistributedCache("customTaskRepl", "clustered");
            client.removeDistributedCache("customTaskReplTx", "clustered");
            client.removeDistributedCacheConfiguration(CUSTOM_TEMPLATE_NAME, "clustered");
            client.removeDistributedCacheConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered");
        } else if (ITestUtils.isReplicatedMode()) {
            client.removeReplicatedCache("customTaskRepl", "clustered");
            client.removeReplicatedCache("customTaskReplTx", "clustered");
            client.removeReplicatedCacheConfiguration(CUSTOM_TEMPLATE_NAME, "clustered");
            client.removeReplicatedCacheConfiguration(CUSTOM_TX_TEMPLATE_NAME, "clustered");
        }
        client.disableJmx();
    }
}

