/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.test.TestingUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="off-heap")})
public class LocalScriptOffHeapIT {
    @InfinispanResource(value="off-heap")
    RemoteInfinispanServer server1;
    private static RemoteCacheManager remoteCacheManager;

    @Before
    public void setUp() {
        if (remoteCacheManager == null) {
            remoteCacheManager = ITestUtils.createCacheManager(this.server1);
        }
    }

    @Test
    public void testSimpleScript() throws IOException {
        this.addScripts("test.js");
        RemoteCache rc = remoteCacheManager.getCache("off-heap-default");
        rc.clear();
        rc.put((Object)"keyA", (Object)"A");
        rc.put((Object)"keyB", (Object)"B");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", "keyC");
        parameters.put("value", "C");
        int result = (Integer)rc.execute("test.js", parameters);
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testStreamingScript() throws IOException {
        this.addScripts("stream.js");
        RemoteCache rc = remoteCacheManager.getCache("off-heap-default");
        rc.clear();
        rc.put((Object)"key1", (Object)"Lorem ipsum dolor sit amet");
        rc.put((Object)"key2", (Object)"consectetur adipiscing elit");
        rc.put((Object)"key3", (Object)"sed do eiusmod tempor incididunt ut labore et dolore magna aliqua");
        Map result = (Map)rc.execute("stream.js", Collections.emptyMap());
        Assert.assertEquals((long)19L, (long)result.size());
    }

    private void addScripts(String script) throws IOException {
        RemoteCache scriptCache = remoteCacheManager.getCache("___script_cache");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(script);){
            scriptCache.put((Object)script, (Object)TestingUtil.loadFileAsString((InputStream)in));
        }
    }
}

