/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.category.Task;
import org.infinispan.server.test.task.servertask.PriceTask;
import org.infinispan.server.test.task.servertask.SpotPrice;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.tasks.ServerTask;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Task.class})
public class LocalServerTestCompatModeIT {
    static final String DEPLOY_PATH = "/standalone/deployments/price-task.jar";
    static final String INFINISPAN_SERVER = "standalone-deployed-pojos";
    @InfinispanResource(value="standalone-deployed-pojos")
    RemoteInfinispanServer server;

    @BeforeClass
    public static void before() throws Exception {
        String serverDir = System.getProperty("server1.dist");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(SpotPrice.class)).addClass(PriceTask.class)).addAsServiceProvider(ServerTask.class, new Class[]{PriceTask.class});
        File f = new File(serverDir, DEPLOY_PATH);
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(f, true);
    }

    @AfterClass
    public static void undeploy() {
        File f;
        String serverDir = System.getProperty("server1.dist");
        File jar = new File(serverDir, DEPLOY_PATH);
        if (jar.exists()) {
            jar.delete();
        }
        if ((f = new File(serverDir, "/standalone/deployments/price-task.jar.deployed")).exists()) {
            f.delete();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-deployed-pojos")})
    public void shouldRunPriceTask() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        RemoteCache remoteCache = rcm.getCache();
        Instant now = Instant.now();
        remoteCache.put((Object)1, (Object)new SpotPrice("RHT", now, Float.valueOf(500.0f)));
        remoteCache.put((Object)2, (Object)new SpotPrice("RHT", now.plus(15L, ChronoUnit.MINUTES), Float.valueOf(500.0f)));
        remoteCache.put((Object)3, (Object)new SpotPrice("RHT", now.plus(30L, ChronoUnit.MINUTES), Float.valueOf(515.0f)));
        remoteCache.put((Object)4, (Object)new SpotPrice("RHT", now.plus(45L, ChronoUnit.MINUTES), Float.valueOf(518.67f)));
        remoteCache.put((Object)5, (Object)new SpotPrice("GOOG", now.plus(48L, ChronoUnit.MINUTES), Float.valueOf(123.67f)));
        remoteCache.put((Object)6, (Object)new SpotPrice("RHT", now.plus(60L, ChronoUnit.MINUTES), Float.valueOf(523.2f)));
        remoteCache.put((Object)7, (Object)new SpotPrice("RHT", now.plus(75L, ChronoUnit.MINUTES), Float.valueOf(520.1f)));
        remoteCache.put((Object)8, (Object)new SpotPrice("RHT", now.plus(90L, ChronoUnit.MINUTES), Float.valueOf(504.0f)));
        remoteCache.put((Object)9, (Object)new SpotPrice("GOOG", now.plus(94L, ChronoUnit.MINUTES), Float.valueOf(223.0f)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ticker", "RHT");
        params.put("action", "avgPrice");
        Double avg = (Double)remoteCache.execute("PriceTask", params);
        Assert.assertEquals((double)511.0, (double)avg, (double)1.0);
    }
}

