/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task.servertask;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.tasks.ServerTask;
import org.infinispan.tasks.TaskContext;

public class JSExecutingServerTask
implements ServerTask {
    public static final String NAME = "jsexecutor_task";
    public static final String CACHE_NAME = "taskAccessible";
    public static final String CACHE_NAME_PARAMETER = "cacheName";
    private TaskContext taskContext;

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public String getName() {
        return NAME;
    }

    public Object call() throws Exception {
        Cache cache = (Cache)this.taskContext.getCache().get();
        EmbeddedCacheManager cacheManager = cache.getCacheManager();
        String cacheName = this.getCacheName();
        if (this.taskContext.getParameters().isPresent() && ((Map)this.taskContext.getParameters().get()).get(CACHE_NAME_PARAMETER) != null) {
            cacheName = (String)((Map)this.taskContext.getParameters().get()).get(CACHE_NAME_PARAMETER);
        }
        Cache usedCache = cacheManager.getCache(cacheName);
        ScriptingManager scriptingManager = (ScriptingManager)cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        this.loadScript(scriptingManager, "/stream_serverTask.js");
        TaskContext taskContext = new TaskContext().cache((Cache)usedCache.getAdvancedCache().withMediaType("application/x-java-object", "application/x-java-object"));
        return scriptingManager.runScript("/stream_serverTask.js", taskContext).get();
    }

    public String getCacheName() {
        return CACHE_NAME;
    }

    private void loadScript(ScriptingManager scriptingManager, String scriptName) throws IOException {
        try (InputStream is = JSExecutingServerTask.class.getResourceAsStream("/" + scriptName);){
            StringBuilder sb = new StringBuilder();
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            String line = r.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = r.readLine();
            }
            String script = sb.toString();
            scriptingManager.addScript(scriptName, script);
        }
    }
}

