/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util.security;

import java.io.File;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.infinispan.client.hotrod.configuration.SaslStrength;
import org.infinispan.client.hotrod.security.VoidCallbackHandler;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.security.SimpleLoginHandler;

public class SecurityConfigurationHelper
extends ConfigurationBuilder {
    public static final String DEFAULT_TEST_REALM = "ApplicationRealm";
    public static final String DEFAULT_KEYSTORE_PATH = ITestUtils.SERVER_CONFIG_DIR + File.separator + "keystore_client.jks";
    public static final String DEFAULT_KEYSTORE_PASSWORD = "secret";
    public static final String DEFAULT_TRUSTSTORE_PATH = ITestUtils.SERVER_CONFIG_DIR + File.separator + "ca.jks";
    public static final String DEFAULT_TRUSTSTORE_PASSWORD = "secret";
    private final String saslMech;

    public SecurityConfigurationHelper(String saslMech) {
        this.saslMech = saslMech;
    }

    public SecurityConfigurationHelper() {
        this.saslMech = null;
    }

    public SecurityConfigurationHelper forCredentials(String login, String password) {
        this.security().authentication().callbackHandler((CallbackHandler)new SimpleLoginHandler(login, password, DEFAULT_TEST_REALM));
        return this;
    }

    public SecurityConfigurationHelper forSubject(Subject subj) {
        this.security().authentication().clientSubject(subj).callbackHandler((CallbackHandler)new SimpleLoginHandler("", ""));
        return this;
    }

    public SecurityConfigurationHelper forExternalAuth() {
        this.security().authentication().callbackHandler((CallbackHandler)new VoidCallbackHandler());
        return this;
    }

    public SecurityConfigurationHelper withDefaultSsl() {
        this.security().ssl().enable().keyStoreFileName(DEFAULT_KEYSTORE_PATH).keyStorePassword("secret".toCharArray()).trustStoreFileName(DEFAULT_TRUSTSTORE_PATH).trustStorePassword("secret".toCharArray());
        return this;
    }

    public SecurityConfigurationHelper withSni(String sni) {
        this.security().ssl().sniHostName(sni);
        return this;
    }

    public SecurityConfigurationHelper withDefaultQop() {
        this.security().authentication().saslQop(new SaslQop[]{SaslQop.AUTH_CONF}).saslStrength(new SaslStrength[]{SaslStrength.HIGH, SaslStrength.MEDIUM, SaslStrength.LOW});
        return this;
    }

    public SecurityConfigurationHelper forIspnServer(RemoteInfinispanServer ispnServer) {
        String hostname = ispnServer.getHotrodEndpoint().getInetAddress().getHostName();
        this.addServer().host(hostname).port(ispnServer.getHotrodEndpoint().getPort());
        this.security().authentication().saslMechanism(this.saslMech).enable();
        return this;
    }

    public SecurityConfigurationHelper withServerName(String serverName) {
        this.security().authentication().serverName(serverName);
        return this;
    }
}

