/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.dto;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okio.Buffer;
import okio.BufferedSink;
import org.influxdb.InfluxDBIOException;
import org.influxdb.querybuilder.Appendable;

public class Query {
    private final String command;
    private final String database;
    private final boolean requiresPost;
    protected final Map<String, Object> params = new HashMap<String, Object>();

    public Query(String command) {
        this(command, null);
    }

    public Query(String command, String database) {
        this(command, database, false);
    }

    public Query(String command, String database, boolean requiresPost) {
        this.command = command;
        this.database = database;
        this.requiresPost = requiresPost;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandWithUrlEncoded() {
        return Query.encode(this.command);
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean requiresPost() {
        return this.requiresPost;
    }

    public Query bindParameter(String placeholder, Object value) {
        this.params.put(placeholder, value);
        return this;
    }

    public boolean hasBoundParameters() {
        return !this.params.isEmpty();
    }

    public String getParameterJsonWithUrlEncoded() {
        try {
            String jsonParameterObject = this.createJsonObject(this.params);
            String urlEncodedJsonParameterObject = Query.encode(jsonParameterObject);
            return urlEncodedJsonParameterObject;
        }
        catch (IOException e) {
            throw new InfluxDBIOException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.command, query.command) && Objects.equals(this.database, query.database) && this.params.equals(query.params);
    }

    public int hashCode() {
        int prime = 31;
        int result = Objects.hashCode(this.command);
        result = 31 * result + Objects.hashCode(this.database);
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public static String encode(String command) {
        try {
            return URLEncoder.encode(command, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Every JRE must support UTF-8", e);
        }
    }

    private String createJsonObject(Map<String, Object> parameterMap) throws IOException {
        Buffer b = new Buffer();
        JsonWriter writer = JsonWriter.of((BufferedSink)b);
        writer.beginObject();
        for (Map.Entry<String, Object> pair : parameterMap.entrySet()) {
            String name = pair.getKey();
            Object value = pair.getValue();
            if (value instanceof Number) {
                Number number = (Number)value;
                writer.name(name).value(number);
                continue;
            }
            if (value instanceof String) {
                writer.name(name).value((String)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.name(name).value((Boolean)value);
                continue;
            }
            if (value instanceof Appendable) {
                StringBuilder stringBuilder = new StringBuilder();
                ((Appendable)value).appendTo(stringBuilder);
                writer.name(name).value(stringBuilder.toString());
                continue;
            }
            writer.name(name).value(String.valueOf(value));
        }
        writer.endObject();
        return b.readString(Charset.forName("utf-8"));
    }
}

