/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;

@FunctionalInterface
public interface TypeMapper {
    public static final TypeMapper EMPTY = typeVariable -> null;

    public static TypeMapper of(ParameterizedType type, Class<?> clazz) {
        TypeVariable<Class<?>>[] typeVariables = clazz.getTypeParameters();
        Type[] types = type.getActualTypeArguments();
        if (types.length != typeVariables.length) {
            throw new IllegalStateException("Mismatched lengths for type variables and actual types");
        }
        HashMap typeMapping = new HashMap(typeVariables.length);
        for (int i = 0; i < typeVariables.length; ++i) {
            typeMapping.put(typeVariables[i], types[i]);
        }
        return typeMapping::get;
    }

    public static TypeMapper empty() {
        return EMPTY;
    }

    default public Type resolve(Type type) {
        if (type instanceof TypeVariable) {
            Type resolvedType = this.get((TypeVariable)type);
            if (resolvedType == null) {
                throw new IllegalStateException("Could not resolve type " + type);
            }
            return resolvedType;
        }
        return type;
    }

    public Type get(TypeVariable<?> var1);
}

