/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.instancio.Random;
import org.instancio.exception.InstancioApiException;
import org.instancio.internal.ThreadLocalRandom;
import org.instancio.internal.ThreadLocalSettings;
import org.instancio.internal.context.Global;
import org.instancio.internal.random.DefaultRandom;
import org.instancio.internal.random.Seeds;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.junit.Seed;
import org.instancio.junit.WithSettings;
import org.instancio.settings.Settings;
import org.junit.jupiter.api.extension.ExtensionContext;

final class ExtensionSupport {
    static void processAnnotations(ExtensionContext context, ThreadLocalRandom threadLocalRandom, ThreadLocalSettings threadLocalSettings) {
        try {
            ExtensionSupport.processWithSettingsAnnotation(context, threadLocalSettings);
            ExtensionSupport.processSeedAnnotation(context, threadLocalRandom);
        }
        catch (Exception ex) {
            threadLocalRandom.remove();
            threadLocalSettings.remove();
            throw ex;
        }
    }

    private static void processSeedAnnotation(ExtensionContext context, ThreadLocalRandom threadLocalRandom) {
        Optional testMethod = context.getTestMethod();
        if (testMethod.isPresent()) {
            Seed seedAnnotation = ((Method)testMethod.get()).getAnnotation(Seed.class);
            long seed = seedAnnotation != null ? seedAnnotation.value() : (Global.getConfiguredRandom() != null ? Global.getConfiguredRandom().getSeed() : Seeds.randomSeed());
            threadLocalRandom.set((Random)new DefaultRandom(seed));
        }
    }

    private static void processWithSettingsAnnotation(ExtensionContext context, ThreadLocalSettings threadLocalSettings) {
        Optional testClass = context.getTestClass();
        if (!testClass.isPresent()) {
            return;
        }
        List fields = ReflectionUtils.getAnnotatedFields((Class)((Class)testClass.get()), WithSettings.class);
        if (fields.size() > 1) {
            throw new InstancioApiException(String.format("%nFound more than one field annotated '@WithSettings':%n%n%s", fields.stream().map(Field::toString).collect(Collectors.joining(System.lineSeparator()))));
        }
        if (fields.size() == 1) {
            Field field = (Field)fields.get(0);
            Optional testInstance = context.getTestInstance();
            Object settings = ReflectionUtils.getFieldValue((Field)field, testInstance.orElse(null));
            if (testInstance.isPresent() && settings == null) {
                throw new InstancioApiException(String.format("%n@WithSettings must be annotated on a non-null field.", new Object[0]));
            }
            if (settings == null) {
                throw new InstancioApiException(String.format("%n@WithSettings must be annotated on a non-null field.%nIf @WithSettings is used with a @ParameterizedTest, the Settings field must be static.", new Object[0]));
            }
            if (!(settings instanceof Settings)) {
                throw new InstancioApiException(String.format("%n@WithSettings must be annotated on a Settings field.%n%nFound annotation on: %s", field));
            }
            threadLocalSettings.set((Settings)settings);
        }
    }

    private ExtensionSupport() {
    }
}

