/*
 * Decompiled with CFR 0.152.
 */
package jota;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import jota.IotaAPIService;
import jota.IotaLocalPoW;
import jota.dto.request.IotaAttachToTangleRequest;
import jota.dto.request.IotaBroadcastTransactionRequest;
import jota.dto.request.IotaCheckConsistencyRequest;
import jota.dto.request.IotaCommandRequest;
import jota.dto.request.IotaFindTransactionsRequest;
import jota.dto.request.IotaGetBalancesRequest;
import jota.dto.request.IotaGetInclusionStateRequest;
import jota.dto.request.IotaGetTransactionsToApproveRequest;
import jota.dto.request.IotaGetTrytesRequest;
import jota.dto.request.IotaNeighborsRequest;
import jota.dto.request.IotaStoreTransactionsRequest;
import jota.dto.request.IotaWereAddressesSpentFromRequest;
import jota.dto.response.AddNeighborsResponse;
import jota.dto.response.BroadcastTransactionsResponse;
import jota.dto.response.CheckConsistencyResponse;
import jota.dto.response.FindTransactionResponse;
import jota.dto.response.GetAttachToTangleResponse;
import jota.dto.response.GetBalancesResponse;
import jota.dto.response.GetInclusionStateResponse;
import jota.dto.response.GetNeighborsResponse;
import jota.dto.response.GetNodeInfoResponse;
import jota.dto.response.GetTipsResponse;
import jota.dto.response.GetTransactionsToApproveResponse;
import jota.dto.response.GetTrytesResponse;
import jota.dto.response.InterruptAttachingToTangleResponse;
import jota.dto.response.RemoveNeighborsResponse;
import jota.dto.response.StoreTransactionsResponse;
import jota.dto.response.WereAddressesSpentFromResponse;
import jota.error.ArgumentException;
import jota.model.Transaction;
import jota.utils.Checksum;
import jota.utils.InputValidator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class IotaAPICore {
    private static final String X_IOTA_API_VERSION_HEADER_NAME = "X-IOTA-API-Version";
    private static final String X_IOTA_API_VERSION_HEADER_VALUE = "1";
    private static final Logger log = LoggerFactory.getLogger(IotaAPICore.class);
    private IotaAPIService service;
    private String protocol;
    private String host;
    private String port;
    private IotaLocalPoW localPoW;

    protected IotaAPICore(Builder<?> builder) {
        this.protocol = builder.protocol;
        this.host = builder.host;
        this.port = builder.port;
        this.localPoW = builder.localPoW;
        this.postConstruct();
    }

    protected static <tt> retrofit2.Response<tt> wrapCheckedException(Call<tt> call) throws ArgumentException {
        try {
            retrofit2.Response res = call.execute();
            String error = "";
            if (res.errorBody() != null) {
                error = res.errorBody().string();
            }
            if (res.code() == 400) {
                throw new ArgumentException(error);
            }
            if (res.code() == 401) {
                throw new IllegalAccessError("401 " + error);
            }
            if (res.code() == 500) {
                throw new IllegalAccessError("500 " + error);
            }
            if (!res.isSuccessful()) {
                throw new ArgumentException(res.message());
            }
            return res;
        }
        catch (IOException e) {
            log.error("Execution of the API call raised exception. IOTA Node not reachable?", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static String env(String env, String def) {
        String value = System.getenv(env);
        if (value == null) {
            log.warn("Environment variable '{}' is not defined, and actual value has not been specified. Rolling back to default value: '{}'", (Object)env, (Object)def);
            return def;
        }
        return value;
    }

    private void postConstruct() {
        String nodeUrl = this.protocol + "://" + this.host + ":" + this.port;
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(5000L, TimeUnit.SECONDS).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Request newRequest = request.newBuilder().addHeader(IotaAPICore.X_IOTA_API_VERSION_HEADER_NAME, IotaAPICore.X_IOTA_API_VERSION_HEADER_VALUE).build();
                return chain.proceed(newRequest);
            }
        }).connectTimeout(5000L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(nodeUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(client).build();
        this.service = (IotaAPIService)retrofit.create(IotaAPIService.class);
        log.debug("Jota-API Java proxy pointing to node url: '{}'", (Object)nodeUrl);
    }

    public GetNodeInfoResponse getNodeInfo() throws ArgumentException {
        Call<GetNodeInfoResponse> res = this.service.getNodeInfo(IotaCommandRequest.createNodeInfoRequest());
        return (GetNodeInfoResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public GetNeighborsResponse getNeighbors() throws ArgumentException {
        Call<GetNeighborsResponse> res = this.service.getNeighbors(IotaCommandRequest.createGetNeighborsRequest());
        return (GetNeighborsResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public AddNeighborsResponse addNeighbors(String ... uris) throws ArgumentException {
        Call<AddNeighborsResponse> res = this.service.addNeighbors(IotaNeighborsRequest.createAddNeighborsRequest(uris));
        return (AddNeighborsResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public RemoveNeighborsResponse removeNeighbors(String ... uris) throws ArgumentException {
        Call<RemoveNeighborsResponse> res = this.service.removeNeighbors(IotaNeighborsRequest.createRemoveNeighborsRequest(uris));
        return (RemoveNeighborsResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public GetTipsResponse getTips() throws ArgumentException {
        Call<GetTipsResponse> res = this.service.getTips(IotaCommandRequest.createGetTipsRequest());
        return (GetTipsResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public FindTransactionResponse findTransactions(String[] addresses, String[] tags, String[] approvees, String[] bundles) throws ArgumentException {
        IotaFindTransactionsRequest findTransRequest = IotaFindTransactionsRequest.createFindTransactionRequest().byAddresses(addresses).byTags(tags).byApprovees(approvees).byBundles(bundles);
        Call<FindTransactionResponse> res = this.service.findTransactions(findTransRequest);
        return (FindTransactionResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public FindTransactionResponse findTransactionsByAddresses(String ... addresses) throws ArgumentException {
        ArrayList<String> addressesWithoutChecksum = new ArrayList<String>();
        for (String address : addresses) {
            String addressO = Checksum.removeChecksum(address);
            addressesWithoutChecksum.add(addressO);
        }
        return this.findTransactions(addressesWithoutChecksum.toArray(new String[addressesWithoutChecksum.size()]), null, null, null);
    }

    public FindTransactionResponse findTransactionsByBundles(String ... bundles) throws ArgumentException {
        return this.findTransactions(null, null, null, bundles);
    }

    public FindTransactionResponse findTransactionsByApprovees(String ... approvees) throws ArgumentException {
        return this.findTransactions(null, null, approvees, null);
    }

    public FindTransactionResponse findTransactionsByDigests(String ... digests) throws ArgumentException {
        return this.findTransactions(null, digests, null, null);
    }

    public GetInclusionStateResponse getInclusionStates(String[] transactions, String[] tips) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(transactions)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfHashes(tips)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        Call<GetInclusionStateResponse> res = this.service.getInclusionStates(IotaGetInclusionStateRequest.createGetInclusionStateRequest(transactions, tips));
        return (GetInclusionStateResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public GetTrytesResponse getTrytes(String ... hashes) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(hashes)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        Call<GetTrytesResponse> res = this.service.getTrytes(IotaGetTrytesRequest.createGetTrytesRequest(hashes));
        return (GetTrytesResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth, String reference) throws ArgumentException {
        Call<GetTransactionsToApproveResponse> res = this.service.getTransactionsToApprove(IotaGetTransactionsToApproveRequest.createIotaGetTransactionsToApproveRequest(depth, reference));
        return (GetTransactionsToApproveResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth) throws ArgumentException {
        return this.getTransactionsToApprove(depth, null);
    }

    private GetBalancesResponse getBalances(Integer threshold, String[] addresses, String[] tips) throws ArgumentException {
        Call<GetBalancesResponse> res = this.service.getBalances(IotaGetBalancesRequest.createIotaGetBalancesRequest(threshold, addresses, tips));
        return (GetBalancesResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses, List<String> tips) throws ArgumentException {
        ArrayList<String> addressesWithoutChecksum = new ArrayList<String>();
        for (String address : addresses) {
            String addressO = Checksum.removeChecksum(address);
            addressesWithoutChecksum.add(addressO);
        }
        String[] tipsArray = tips != null ? tips.toArray(new String[tips.size()]) : null;
        return this.getBalances(threshold, addressesWithoutChecksum.toArray(new String[addresses.size()]), tipsArray);
    }

    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses) throws ArgumentException {
        return this.getBalances(threshold, addresses, null);
    }

    public WereAddressesSpentFromResponse wereAddressesSpentFrom(String ... addresses) throws ArgumentException {
        if (!InputValidator.isAddressesArrayValid(addresses)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        Call<WereAddressesSpentFromResponse> res = this.service.wereAddressesSpentFrom(IotaWereAddressesSpentFromRequest.create(addresses));
        return (WereAddressesSpentFromResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public CheckConsistencyResponse checkConsistency(String ... tails) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(tails)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        Call<CheckConsistencyResponse> res = this.service.checkConsistency(IotaCheckConsistencyRequest.create(tails));
        return (CheckConsistencyResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public GetAttachToTangleResponse attachToTangle(String trunkTransaction, String branchTransaction, Integer minWeightMagnitude, String ... trytes) throws ArgumentException {
        if (!InputValidator.isHash(trunkTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isHash(branchTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.areTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid trytes provided.");
        }
        if (this.localPoW != null) {
            String[] resultTrytes = new String[trytes.length];
            String previousTransaction = null;
            for (int i = 0; i < trytes.length; ++i) {
                Transaction txn = new Transaction(trytes[i]);
                txn.setTrunkTransaction(previousTransaction == null ? trunkTransaction : previousTransaction);
                txn.setBranchTransaction(previousTransaction == null ? branchTransaction : trunkTransaction);
                if (txn.getTag().isEmpty() || txn.getTag().matches("9*")) {
                    txn.setTag(txn.getObsoleteTag());
                }
                txn.setAttachmentTimestamp(System.currentTimeMillis());
                txn.setAttachmentTimestampLowerBound(0L);
                txn.setAttachmentTimestampUpperBound(3812798742493L);
                resultTrytes[i] = this.localPoW.performPoW(txn.toTrytes(), minWeightMagnitude);
                previousTransaction = new Transaction(resultTrytes[i]).getHash();
            }
            return new GetAttachToTangleResponse(resultTrytes);
        }
        Call<GetAttachToTangleResponse> res = this.service.attachToTangle(IotaAttachToTangleRequest.createAttachToTangleRequest(trunkTransaction, branchTransaction, minWeightMagnitude, trytes));
        return (GetAttachToTangleResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public InterruptAttachingToTangleResponse interruptAttachingToTangle() throws ArgumentException {
        Call<InterruptAttachingToTangleResponse> res = this.service.interruptAttachingToTangle(IotaCommandRequest.createInterruptAttachToTangleRequest());
        return (InterruptAttachingToTangleResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public BroadcastTransactionsResponse broadcastTransactions(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfAttachedTrytes(trytes)) {
            throw new ArgumentException("Invalid attached trytes provided.");
        }
        Call<BroadcastTransactionsResponse> res = this.service.broadcastTransactions(IotaBroadcastTransactionRequest.createBroadcastTransactionsRequest(trytes));
        return (BroadcastTransactionsResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public StoreTransactionsResponse storeTransactions(String ... trytes) throws ArgumentException {
        Call<StoreTransactionsResponse> res = this.service.storeTransactions(IotaStoreTransactionsRequest.createStoreTransactionsRequest(trytes));
        return (StoreTransactionsResponse)IotaAPICore.wrapCheckedException(res).body();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public static class Builder<T extends Builder<T>> {
        String protocol;
        String host;
        String port;
        IotaLocalPoW localPoW;
        private FileReader fileReader = null;
        private BufferedReader bufferedReader = null;
        private Properties nodeConfig = null;

        public IotaAPICore build() {
            if (null == this.protocol) {
                this.protocol = this.getFromConfigurationOrEnvironment("iota.node.protocol", "IOTA_NODE_PROTOCOL", "http");
            }
            if (null == this.host) {
                this.host = this.getFromConfigurationOrEnvironment("iota.node.host", "IOTA_NODE_HOST", "localhost");
            }
            if (null == this.port) {
                this.port = this.getFromConfigurationOrEnvironment("iota.node.port", "IOTA_NODE_PORT", "14265");
            }
            return new IotaAPICore(this);
        }

        private String getFromConfigurationOrEnvironment(String propertyKey, String envName, String defaultValue) {
            if (this.getNodeConfig().getProperty(propertyKey) != null) {
                return this.nodeConfig.getProperty(propertyKey);
            }
            return IotaAPICore.env(envName, defaultValue);
        }

        private Properties getNodeConfig() {
            if (null != this.nodeConfig) {
                return this.nodeConfig;
            }
            this.nodeConfig = new Properties();
            if (null == this.fileReader) {
                try {
                    this.fileReader = new FileReader("../node_config.properties");
                    if (null == this.bufferedReader) {
                        this.bufferedReader = new BufferedReader(this.fileReader);
                    }
                    this.nodeConfig.load(this.bufferedReader);
                }
                catch (IOException e) {
                    log.debug("node_config.properties not found. Rolling back for another solution...");
                }
            }
            return this.nodeConfig;
        }

        public T config(Properties properties) {
            this.nodeConfig = properties;
            return (T)this;
        }

        public T host(String host) {
            this.host = host;
            return (T)this;
        }

        public T port(String port) {
            this.port = port;
            return (T)this;
        }

        public T protocol(String protocol) {
            this.protocol = protocol;
            return (T)this;
        }

        public T localPoW(IotaLocalPoW localPoW) {
            this.localPoW = localPoW;
            return (T)this;
        }
    }
}

