/*
 * Decompiled with CFR 0.152.
 */
package jota.pow;

import java.util.LinkedHashSet;
import jota.pow.JCurl;
import jota.pow.SpongeFactory;
import jota.utils.Pair;
import org.bouncycastle.jcajce.provider.digest.Keccak;

public class Kerl
extends JCurl {
    private static final int HASH_LENGTH = 243;
    private static final int BIT_HASH_LENGTH = 384;
    private static final int BYTE_HASH_LENGTH = 48;
    private static final int RADIX = 3;
    private static final int MAX_TRIT_VALUE = 1;
    private static final int MIN_TRIT_VALUE = -1;
    private final Keccak.Digest384 keccak = new Keccak.Digest384();
    private byte[] byte_state = new byte[48];
    private int[] trit_state = new int[243];
    private static final int[] HALF_3 = new int[]{-1513191068, -1627359639, 344215631, 987627737, 203704430, 1352113495, 2040841986, 1220259382, -1443463029, -1442404347, -1468027937, 1583999983};
    private static int BYTE_LENGTH = 48;
    private static int INT_LENGTH = BYTE_LENGTH / 4;

    Kerl() {
        super(SpongeFactory.Mode.CURLP81);
    }

    private static final long toUnsignedLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }

    private static int sum(int[] toSum) {
        int sum = 0;
        for (int aToSum : toSum) {
            sum += aToSum;
        }
        return sum;
    }

    public static byte[] convertTritsToBytes(int[] trits) {
        int i;
        if (trits.length != 243) {
            throw new RuntimeException("Input trits length must be 243in length");
        }
        int[] base = new int[INT_LENGTH];
        LinkedHashSet<Integer> setUniqueNumbers = new LinkedHashSet<Integer>();
        for (int x : trits) {
            setUniqueNumbers.add(x);
        }
        if (setUniqueNumbers.size() == 1 && setUniqueNumbers.contains(-1)) {
            base = (int[])HALF_3.clone();
            Kerl.bigintNot(base);
            Kerl.bigintAdd(base, 1);
        } else {
            int size = INT_LENGTH;
            i = 242;
            while (i-- > 0) {
                int in;
                int sz;
                int sz2 = size;
                int carry = 0;
                for (int j = 0; j < sz2; ++j) {
                    long v = Kerl.toUnsignedLong(base[j]) * Kerl.toUnsignedLong(3) + Kerl.toUnsignedLong(carry);
                    carry = (int)(v >> 32 & 0xFFFFFFFFFFFFFFFFL);
                    base[j] = (int)(v & 0xFFFFFFFFFFFFFFFFL);
                }
                if (carry > 0) {
                    base[sz2] = carry;
                    ++size;
                }
                if ((sz = Kerl.bigintAdd(base, in = trits[i] + 1)) <= size) continue;
                size = sz;
            }
            if (Kerl.sum(base) != 0) {
                if (Kerl.bigintCmp(HALF_3, base) <= 0) {
                    base = Kerl.bigintSub(base, HALF_3);
                } else {
                    base = Kerl.bigintSub(HALF_3, base);
                    Kerl.bigintNot(base);
                    Kerl.bigintAdd(base, 1);
                }
            }
        }
        byte[] out = new byte[BYTE_LENGTH];
        for (i = 0; i < INT_LENGTH; ++i) {
            out[i * 4 + 0] = (byte)((base[INT_LENGTH - 1 - i] & 0xFF000000) >> 24);
            out[i * 4 + 1] = (byte)((base[INT_LENGTH - 1 - i] & 0xFF0000) >> 16);
            out[i * 4 + 2] = (byte)((base[INT_LENGTH - 1 - i] & 0xFF00) >> 8);
            out[i * 4 + 3] = (byte)((base[INT_LENGTH - 1 - i] & 0xFF) >> 0);
        }
        return out;
    }

    public static int[] convertBytesToTrits(byte[] bytes) {
        int[] out;
        block14: {
            int i;
            int[] base;
            block13: {
                base = new int[INT_LENGTH];
                out = new int[243];
                out[242] = 0;
                if (bytes.length != BYTE_LENGTH) {
                    throw new RuntimeException("Input base must be " + BYTE_LENGTH + " in length");
                }
                for (int i2 = 0; i2 < INT_LENGTH; ++i2) {
                    base[Kerl.INT_LENGTH - 1 - i2] = Kerl.toUnsignedInt(bytes[i2 * 4]) << 24;
                    int n = INT_LENGTH - 1 - i2;
                    base[n] = base[n] | Kerl.toUnsignedInt(bytes[i2 * 4 + 1]) << 16;
                    int n2 = INT_LENGTH - 1 - i2;
                    base[n2] = base[n2] | Kerl.toUnsignedInt(bytes[i2 * 4 + 2]) << 8;
                    int n3 = INT_LENGTH - 1 - i2;
                    base[n3] = base[n3] | Kerl.toUnsignedInt(bytes[i2 * 4 + 3]);
                }
                if (Kerl.bigintCmp(base, HALF_3) != 0) break block13;
                int val = 0;
                if (base[0] > 0) {
                    val = -1;
                } else if (base[0] < 0) {
                    val = 1;
                }
                for (int i3 = 0; i3 < 242; ++i3) {
                    out[i3] = val;
                }
                break block14;
            }
            boolean flipTrits = false;
            if (Kerl.toUnsignedLong(base[INT_LENGTH - 1]) >> 31 != 0L) {
                Kerl.bigintNot(base);
                if (Kerl.bigintCmp(base, HALF_3) > 0) {
                    base = Kerl.bigintSub(base, HALF_3);
                    flipTrits = true;
                } else {
                    Kerl.bigintAdd(base, 1);
                    base = Kerl.bigintSub(HALF_3, base);
                }
            } else {
                base = Kerl.bigintAdd(HALF_3, base);
            }
            int size = INT_LENGTH;
            int remainder = 0;
            for (i = 0; i < 242; ++i) {
                remainder = 0;
                for (int j = size - 1; j >= 0; --j) {
                    long lhs = Kerl.toUnsignedLong(remainder) << 32 | Kerl.toUnsignedLong(base[j]);
                    long rhs = Kerl.toUnsignedLong(3);
                    int q = (int)(lhs / rhs);
                    int r = (int)(lhs % rhs);
                    base[j] = q;
                    remainder = r;
                }
                out[i] = remainder - 1;
            }
            if (!flipTrits) break block14;
            for (i = 0; i < out.length; ++i) {
                out[i] = -out[i];
            }
        }
        return out;
    }

    private static void bigintNot(int[] base) {
        for (int i = 0; i < base.length; ++i) {
            base[i] = ~base[i];
        }
    }

    private static int bigintAdd(int[] base, int rh) {
        Pair<Integer, Boolean> res = Kerl.fullAdd(base[0], rh, false);
        base[0] = (Integer)res.low;
        int j = 1;
        while (((Boolean)res.hi).booleanValue()) {
            res = Kerl.fullAdd(base[j], 0, true);
            base[j] = (Integer)res.low;
            ++j;
        }
        return j;
    }

    private static int[] bigintAdd(int[] lh, int[] rh) {
        int[] out = new int[INT_LENGTH];
        boolean carry = false;
        for (int i = 0; i < INT_LENGTH; ++i) {
            Pair<Integer, Boolean> ret = Kerl.fullAdd(lh[i], rh[i], carry);
            out[i] = (Integer)ret.low;
            carry = (Boolean)ret.hi;
        }
        if (carry) {
            throw new RuntimeException("Exceeded max value.");
        }
        return out;
    }

    private static int bigintCmp(int[] lh, int[] rh) {
        for (int i = INT_LENGTH - 1; i >= 0; --i) {
            int ret = Long.compare(Kerl.toUnsignedLong(lh[i]), Kerl.toUnsignedLong(rh[i]));
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    private static int[] bigintSub(int[] lh, int[] rh) {
        int[] out = new int[INT_LENGTH];
        boolean noborrow = true;
        for (int i = 0; i < INT_LENGTH; ++i) {
            Pair<Integer, Boolean> ret = Kerl.fullAdd(lh[i], ~rh[i], noborrow);
            out[i] = (Integer)ret.low;
            noborrow = (Boolean)ret.hi;
        }
        if (!noborrow) {
            throw new RuntimeException("noborrow");
        }
        return out;
    }

    private static Pair<Integer, Boolean> fullAdd(int ia, int ib, boolean carry) {
        boolean carry1;
        long a = Kerl.toUnsignedLong(ia);
        long b = Kerl.toUnsignedLong(ib);
        long v = a + b;
        long l = v >> 32;
        long r = v & 0xFFFFFFFFFFFFFFFFL;
        boolean bl = carry1 = l != 0L;
        if (carry) {
            v = r + 1L;
        }
        l = v >> 32 & 0xFFFFFFFFFFFFFFFFL;
        r = v & 0xFFFFFFFFFFFFFFFFL;
        boolean carry2 = l != 0L;
        return new Pair<Integer, Boolean>((int)r, carry1 || carry2);
    }

    @Override
    public Kerl reset() {
        this.keccak.reset();
        return this;
    }

    @Override
    public Kerl absorb(int[] trits, int offset, int length) {
        if (length % 243 != 0) {
            throw new RuntimeException("Illegal length: " + length);
        }
        do {
            System.arraycopy(trits, offset, this.trit_state, 0, 243);
            this.trit_state[242] = 0;
            byte[] bytes = Kerl.convertTritsToBytes(this.trit_state);
            this.keccak.update(bytes);
            offset += 243;
        } while ((length -= 243) > 0);
        return this;
    }

    @Override
    public int[] squeeze(int[] trits, int offset, int length) {
        if (length % 243 != 0) {
            throw new RuntimeException("Illegal length: " + length);
        }
        do {
            this.byte_state = this.keccak.digest();
            this.trit_state = Kerl.convertBytesToTrits(this.byte_state);
            this.trit_state[242] = 0;
            System.arraycopy(this.trit_state, 0, trits, offset, 243);
            int i = this.byte_state.length;
            while (i-- > 0) {
                this.byte_state[i] = (byte)(this.byte_state[i] ^ 0xFF);
            }
            this.keccak.update(this.byte_state);
            offset += 243;
        } while ((length -= 243) > 0);
        return trits;
    }

    @Override
    public int[] squeeze(int[] trits) {
        return this.squeeze(trits, 0, trits.length);
    }

    @Override
    public Kerl clone() {
        return new Kerl();
    }
}

