/*
 * Decompiled with CFR 0.152.
 */
package jota.pow.pearldiver;

public class PearlDiver {
    private static final int TRANSACTION_LENGTH = 8019;
    private static final int CURL_HASH_LENGTH = 243;
    private static final int CURL_STATE_LENGTH = 729;
    private static final long HIGH_BITS = -1L;
    private static final long LOW_BITS = 0L;
    private volatile State state;
    private final Object syncObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.syncObj;
        synchronized (object) {
            this.state = State.CANCELLED;
            this.syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean search(final int[] transactionTrits, final int minWeightMagnitude, int numberOfThreads) {
        if (transactionTrits.length != 8019) {
            throw new RuntimeException("Invalid transaction trits length: " + transactionTrits.length);
        }
        if (minWeightMagnitude < 0 || minWeightMagnitude > 243) {
            throw new RuntimeException("Invalid min weight magnitude: " + minWeightMagnitude);
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.state = State.RUNNING;
        }
        final long[] midCurlStateLow = new long[729];
        final long[] midCurlStateHigh = new long[729];
        for (int i = 243; i < 729; ++i) {
            midCurlStateLow[i] = -1L;
            midCurlStateHigh[i] = -1L;
        }
        int offset = 0;
        long[] curlScratchpadLow = new long[729];
        long[] curlScratchpadHigh = new long[729];
        int i = 32;
        while (i-- > 0) {
            block26: for (int j = 0; j < 243; ++j) {
                switch (transactionTrits[offset++]) {
                    case 0: {
                        midCurlStateLow[j] = -1L;
                        midCurlStateHigh[j] = -1L;
                        continue block26;
                    }
                    case 1: {
                        midCurlStateLow[j] = 0L;
                        midCurlStateHigh[j] = -1L;
                        continue block26;
                    }
                    default: {
                        midCurlStateLow[j] = -1L;
                        midCurlStateHigh[j] = 0L;
                    }
                }
            }
            PearlDiver.transform(midCurlStateLow, midCurlStateHigh, curlScratchpadLow, curlScratchpadHigh);
        }
        block27: for (i = 0; i < 162; ++i) {
            switch (transactionTrits[offset++]) {
                case 0: {
                    midCurlStateLow[i] = -1L;
                    midCurlStateHigh[i] = -1L;
                    continue block27;
                }
                case 1: {
                    midCurlStateLow[i] = 0L;
                    midCurlStateHigh[i] = -1L;
                    continue block27;
                }
                default: {
                    midCurlStateLow[i] = -1L;
                    midCurlStateHigh[i] = 0L;
                }
            }
        }
        midCurlStateLow[162] = -2635249153387078803L;
        midCurlStateHigh[162] = -5270498306774157605L;
        midCurlStateLow[163] = -1010780497189564473L;
        midCurlStateHigh[163] = -8086243977516515777L;
        midCurlStateLow[164] = 9223336921201902079L;
        midCurlStateHigh[164] = -17979214271348737L;
        midCurlStateLow[165] = -18014398375264257L;
        midCurlStateHigh[165] = 0x3FFFFFFFFFFFFFL;
        if (numberOfThreads <= 0) {
            numberOfThreads = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        }
        Thread[] workers = new Thread[numberOfThreads];
        while (numberOfThreads-- > 0) {
            Thread worker;
            final int threadIndex = numberOfThreads;
            workers[threadIndex] = worker = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long[] midCurlStateCopyLow = new long[729];
                    long[] midCurlStateCopyHigh = new long[729];
                    System.arraycopy(midCurlStateLow, 0, midCurlStateCopyLow, 0, 729);
                    System.arraycopy(midCurlStateHigh, 0, midCurlStateCopyHigh, 0, 729);
                    int i = threadIndex;
                    while (i-- > 0) {
                        PearlDiver.increment(midCurlStateCopyLow, midCurlStateCopyHigh, 189, 216);
                    }
                    long[] curlStateLow = new long[729];
                    long[] curlStateHigh = new long[729];
                    long[] curlScratchpadLow = new long[729];
                    long[] curlScratchpadHigh = new long[729];
                    long outMask = 1L;
                    while (PearlDiver.this.state == State.RUNNING) {
                        PearlDiver.increment(midCurlStateCopyLow, midCurlStateCopyHigh, 216, 243);
                        System.arraycopy(midCurlStateCopyLow, 0, curlStateLow, 0, 729);
                        System.arraycopy(midCurlStateCopyHigh, 0, curlStateHigh, 0, 729);
                        PearlDiver.transform(curlStateLow, curlStateHigh, curlScratchpadLow, curlScratchpadHigh);
                        long mask = -1L;
                        int i2 = minWeightMagnitude;
                        while (i2-- > 0 && (mask &= curlStateLow[242 - i2] ^ curlStateHigh[242 - i2] ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
                        }
                        if (mask == 0L) continue;
                        Object object = PearlDiver.this.syncObj;
                        synchronized (object) {
                            if (PearlDiver.this.state == State.RUNNING) {
                                PearlDiver.this.state = State.COMPLETED;
                                while ((outMask & mask) == 0L) {
                                    outMask <<= 1;
                                }
                                for (int i3 = 0; i3 < 243; ++i3) {
                                    transactionTrits[7776 + i3] = (midCurlStateCopyLow[i3] & outMask) == 0L ? 1 : ((midCurlStateCopyHigh[i3] & outMask) == 0L ? -1 : 0);
                                }
                                PearlDiver.this.syncObj.notifyAll();
                            }
                            break;
                        }
                    }
                }
            };
            worker.start();
        }
        try {
            Object threadIndex = this.syncObj;
            synchronized (threadIndex) {
                if (this.state == State.RUNNING) {
                    this.syncObj.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Object object2 = this.syncObj;
            synchronized (object2) {
                this.state = State.CANCELLED;
            }
        }
        for (Thread worker : workers) {
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                Object object3 = this.syncObj;
                synchronized (object3) {
                    this.state = State.CANCELLED;
                }
            }
        }
        return this.state == State.COMPLETED;
    }

    private static void transform(long[] curlStateLow, long[] curlStateHigh, long[] curlScratchpadLow, long[] curlScratchpadHigh) {
        int curlScratchpadIndex = 0;
        for (int round = 0; round < 81; ++round) {
            System.arraycopy(curlStateLow, 0, curlScratchpadLow, 0, 729);
            System.arraycopy(curlStateHigh, 0, curlScratchpadHigh, 0, 729);
            for (int curlStateIndex = 0; curlStateIndex < 729; ++curlStateIndex) {
                long alpha = curlScratchpadLow[curlScratchpadIndex];
                long beta = curlScratchpadHigh[curlScratchpadIndex];
                curlScratchpadIndex = curlScratchpadIndex < 365 ? (curlScratchpadIndex += 364) : (curlScratchpadIndex -= 365);
                long gamma = curlScratchpadHigh[curlScratchpadIndex];
                long delta = (alpha | gamma ^ 0xFFFFFFFFFFFFFFFFL) & (curlScratchpadLow[curlScratchpadIndex] ^ beta);
                curlStateLow[curlStateIndex] = delta ^ 0xFFFFFFFFFFFFFFFFL;
                curlStateHigh[curlStateIndex] = alpha ^ gamma | delta;
            }
        }
    }

    private static void increment(long[] midCurlStateCopyLow, long[] midCurlStateCopyHigh, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (midCurlStateCopyLow[i] != 0L) {
                if (midCurlStateCopyHigh[i] == 0L) {
                    midCurlStateCopyHigh[i] = -1L;
                    break;
                }
                midCurlStateCopyLow[i] = 0L;
                break;
            }
            midCurlStateCopyLow[i] = -1L;
            midCurlStateCopyHigh[i] = 0L;
        }
    }

    static enum State {
        RUNNING,
        CANCELLED,
        COMPLETED;

    }
}

