/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.iota.jota.ApiOptions;
import org.iota.jota.IotaAPICommand;
import org.iota.jota.IotaPoW;
import org.iota.jota.connection.Connection;
import org.iota.jota.dto.request.IotaAttachToTangleRequest;
import org.iota.jota.dto.request.IotaBroadcastTransactionRequest;
import org.iota.jota.dto.request.IotaCheckConsistencyRequest;
import org.iota.jota.dto.request.IotaCommandRequest;
import org.iota.jota.dto.request.IotaCustomRequest;
import org.iota.jota.dto.request.IotaFindTransactionsRequest;
import org.iota.jota.dto.request.IotaGetBalancesRequest;
import org.iota.jota.dto.request.IotaGetInclusionStateRequest;
import org.iota.jota.dto.request.IotaGetTransactionsToApproveRequest;
import org.iota.jota.dto.request.IotaGetTrytesRequest;
import org.iota.jota.dto.request.IotaNeighborsRequest;
import org.iota.jota.dto.request.IotaStoreTransactionsRequest;
import org.iota.jota.dto.request.IotaWereAddressesSpentFromRequest;
import org.iota.jota.dto.response.AddNeighborsResponse;
import org.iota.jota.dto.response.BroadcastTransactionsResponse;
import org.iota.jota.dto.response.CheckConsistencyResponse;
import org.iota.jota.dto.response.FindTransactionResponse;
import org.iota.jota.dto.response.GetAttachToTangleResponse;
import org.iota.jota.dto.response.GetBalancesResponse;
import org.iota.jota.dto.response.GetInclusionStateResponse;
import org.iota.jota.dto.response.GetNeighborsResponse;
import org.iota.jota.dto.response.GetNodeAPIConfigurationResponse;
import org.iota.jota.dto.response.GetNodeInfoResponse;
import org.iota.jota.dto.response.GetTipsResponse;
import org.iota.jota.dto.response.GetTransactionsToApproveResponse;
import org.iota.jota.dto.response.GetTrytesResponse;
import org.iota.jota.dto.response.InterruptAttachingToTangleResponse;
import org.iota.jota.dto.response.IotaCustomResponse;
import org.iota.jota.dto.response.RemoveNeighborsResponse;
import org.iota.jota.dto.response.StoreTransactionsResponse;
import org.iota.jota.dto.response.WereAddressesSpentFromResponse;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Transaction;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.InputValidator;
import org.iota.mddoclet.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IotaAPICore {
    private static final Logger log = LoggerFactory.getLogger(IotaAPICore.class);
    private ApiOptions options;
    protected final List<Connection> nodes = new ArrayList<Connection>();

    protected IotaAPICore(ApiOptions options) {
        this.options = options;
        for (Connection c : options.getNodes()) {
            this.addNode(c);
        }
    }

    public boolean hasNodes() {
        return !this.nodes.isEmpty();
    }

    public Connection getRandomNode() {
        if (!this.hasNodes()) {
            return null;
        }
        int randomNodeIndex = new Random().nextInt(this.nodes.size());
        return this.nodes.get(randomNodeIndex);
    }

    public List<Connection> getNodes() {
        return this.nodes;
    }

    ApiOptions getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addNode(Connection n) {
        try {
            List<Connection> list = this.nodes;
            synchronized (list) {
                Connection c;
                Iterator<Connection> iterator = this.nodes.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    boolean started = n.start();
                    if (started) {
                        this.nodes.add(n);
                        log.debug("Added node: " + n.toString());
                    }
                    return started;
                } while (!(c = iterator.next()).equals(n));
                log.warn("Tried to add a node we allready have: " + n);
                return true;
            }
        }
        catch (Exception e) {
            log.warn("Failed to add node connection to pool due to \"" + e.getMessage() + "\"");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeNode(Connection n) {
        List<Connection> list = this.nodes;
        synchronized (list) {
            int i = 0;
            while (true) {
                if (i >= this.nodes.size()) {
                    return false;
                }
                Connection c = this.nodes.get(i);
                if (c.equals(n)) {
                    c.stop();
                    this.nodes.remove(i);
                    return true;
                }
                ++i;
            }
        }
    }

    public ICurl getCurl() {
        return this.getOptions().getCustomCurl().clone();
    }

    public void setCurl(ICurl localPoW) {
        this.getOptions().setCustomCurl(localPoW);
    }

    public IotaPoW getLocalPoW() {
        return this.getOptions().getLocalPoW();
    }

    public void setLocalPoW(IotaPoW localPoW) {
        this.getOptions().setLocalPoW(localPoW);
    }

    private Connection getNodeFor(IotaAPICommand cmd) {
        if (cmd == null) {
            return this.nodes.get(0);
        }
        return this.nodes.get(0);
    }

    @Document
    public GetNodeInfoResponse getNodeInfo() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.GET_NODE_INFO).getNodeInfo(IotaCommandRequest.createNodeInfoRequest());
    }

    @Document
    public GetNodeAPIConfigurationResponse getNodeAPIConfiguration() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.GET_NODE_API_CONFIGURATION).getNodeAPIConfiguration(IotaCommandRequest.createGetNodeAPIConfiguration());
    }

    @Document
    public GetNeighborsResponse getNeighbors() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.GET_NEIGHBORS).getNeighbors(IotaCommandRequest.createGetNeighborsRequest());
    }

    @Document
    public AddNeighborsResponse addNeighbors(String ... uris) throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.ADD_NEIGHBORS).addNeighbors(IotaNeighborsRequest.createAddNeighborsRequest(uris));
    }

    @Document
    public RemoveNeighborsResponse removeNeighbors(String ... uris) throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.REMOVE_NEIGHBORS).removeNeighbors(IotaNeighborsRequest.createRemoveNeighborsRequest(uris));
    }

    @Document
    public GetTipsResponse getTips() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.GET_TIPS).getTips(IotaCommandRequest.createGetTipsRequest());
    }

    @Document
    public FindTransactionResponse findTransactions(String[] addresses, String[] tags, String[] approvees, String[] bundles) throws ArgumentException {
        String[] addressesWithoutChecksum;
        if (ArrayUtils.isNotEmpty((Object[])addresses)) {
            this.validateAddresses(addresses);
            addressesWithoutChecksum = this.removeChecksumFromAddresses(addresses);
        } else {
            addressesWithoutChecksum = addresses;
        }
        if (ArrayUtils.isNotEmpty((Object[])tags)) {
            this.validateTags(tags);
        }
        if (ArrayUtils.isNotEmpty((Object[])bundles)) {
            this.validateBundles(bundles);
        }
        if (ArrayUtils.isNotEmpty((Object[])approvees)) {
            this.validateApprovees(approvees);
        }
        IotaFindTransactionsRequest findTransRequest = IotaFindTransactionsRequest.createFindTransactionRequest().byAddresses(addressesWithoutChecksum).byTags(tags).byApprovees(approvees).byBundles(bundles);
        return this.getNodeFor(IotaAPICommand.FIND_TRANSACTIONS).findTransactions(findTransRequest);
    }

    @Document
    public IotaCustomResponse callIxi(String module, Map<String, Object> params) throws ArgumentException {
        IotaCustomRequest ixiRequest = IotaCustomRequest.createCustomRequest(module, params);
        return this.getNodeFor(IotaAPICommand.CUSTOM_IXI).customRequest(ixiRequest);
    }

    @Document
    public FindTransactionResponse findTransactionsByAddresses(String ... addresses) throws ArgumentException {
        this.validateAddresses(addresses);
        return this.findTransactions(addresses, null, null, null);
    }

    @Document
    public FindTransactionResponse findTransactionsByBundles(String ... bundles) throws ArgumentException {
        return this.findTransactions(null, null, null, bundles);
    }

    @Document
    public FindTransactionResponse findTransactionsByApprovees(String ... approvees) throws ArgumentException {
        return this.findTransactions(null, null, approvees, null);
    }

    @Deprecated
    public FindTransactionResponse findTransactionsByDigests(String ... digests) throws ArgumentException {
        return this.findTransactionsByTags(digests);
    }

    @Document
    public FindTransactionResponse findTransactionsByTags(String ... tags) throws ArgumentException {
        return this.findTransactions(null, tags, null, null);
    }

    @Document
    public GetInclusionStateResponse getInclusionStates(String ... transactions) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(transactions)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.getNodeFor(IotaAPICommand.GET_INCLUSIONS_STATES).getInclusionStates(IotaGetInclusionStateRequest.createGetInclusionStateRequest(transactions));
    }

    @Document
    public GetTrytesResponse getTrytes(String ... hashes) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(hashes)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.getNodeFor(IotaAPICommand.GET_TRYTES).getTrytes(IotaGetTrytesRequest.createGetTrytesRequest(hashes));
    }

    @Document
    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth, String reference) throws ArgumentException {
        if (depth < 0) {
            throw new ArgumentException("Invalid depth provided. (Between 0 and 15, soft upper bound)");
        }
        return this.getNodeFor(IotaAPICommand.GET_TRANSACTIONS_TO_APPROVE).getTransactionsToApprove(IotaGetTransactionsToApproveRequest.createIotaGetTransactionsToApproveRequest(depth, reference));
    }

    @Document
    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth) throws ArgumentException {
        return this.getTransactionsToApprove(depth, null);
    }

    @Document
    public GetBalancesResponse getBalances(String[] addresses, String[] tips) throws ArgumentException {
        if (tips != null && !InputValidator.isArrayOfHashes(tips)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        this.validateAddresses(addresses);
        String[] addressesWithoutChecksum = this.removeChecksumFromAddresses(addresses);
        return this.getNodeFor(IotaAPICommand.GET_BALANCES).getBalances(IotaGetBalancesRequest.createIotaGetBalancesRequest(addressesWithoutChecksum, tips));
    }

    @Deprecated
    @Document
    public GetBalancesResponse getBalances(Integer threshold, String[] addresses, String[] tips) throws ArgumentException {
        if (threshold < 0 || threshold > 100) {
            throw new ArgumentException("Invalid threshold provided. (Between 0 and 100 incl.)");
        }
        if (tips != null && !InputValidator.isArrayOfHashes(tips)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        this.validateAddresses(addresses);
        String[] addressesWithoutChecksum = this.removeChecksumFromAddresses(addresses);
        return this.getNodeFor(IotaAPICommand.GET_BALANCES).getBalances(IotaGetBalancesRequest.createIotaGetBalancesRequest(threshold, addressesWithoutChecksum, tips));
    }

    @Document
    public GetBalancesResponse getBalances(List<String> addresses, List<String> tips) throws ArgumentException {
        String[] tipsArray = tips != null ? tips.toArray(new String[0]) : null;
        String[] addressesArray = addresses != null ? addresses.toArray(new String[0]) : null;
        return this.getBalances(addressesArray, tipsArray);
    }

    @Deprecated
    @Document
    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses, List<String> tips) throws ArgumentException {
        String[] tipsArray = tips != null ? tips.toArray(new String[0]) : null;
        String[] addressesArray = addresses != null ? addresses.toArray(new String[0]) : null;
        return this.getBalances(threshold, addressesArray, tipsArray);
    }

    @Document
    public GetBalancesResponse getBalances(List<String> addresses) throws ArgumentException {
        return this.getBalances(addresses, null);
    }

    @Deprecated
    @Document
    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses) throws ArgumentException {
        return this.getBalances(threshold, addresses, null);
    }

    @Document
    public WereAddressesSpentFromResponse wereAddressesSpentFrom(String ... addresses) throws ArgumentException {
        this.validateAddresses(addresses);
        String[] addressesWithoutChecksum = this.removeChecksumFromAddresses(addresses);
        return this.getNodeFor(IotaAPICommand.WERE_ADDRESSES_SPENT_FROM).wereAddressesSpentFrom(IotaWereAddressesSpentFromRequest.create(addressesWithoutChecksum));
    }

    @Document
    public CheckConsistencyResponse checkConsistency(String ... tails) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(tails)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.getNodeFor(IotaAPICommand.CHECK_CONSISTENCY).checkConsistency(IotaCheckConsistencyRequest.create(tails));
    }

    @Document
    public GetAttachToTangleResponse attachToTangle(String trunkTransaction, String branchTransaction, Integer minWeightMagnitude, String ... trytes) throws ArgumentException {
        IotaPoW pow = this.getOptions().getLocalPoW();
        if (pow != null) {
            return this.attachToTangleLocalPow(trunkTransaction, branchTransaction, minWeightMagnitude, pow, trytes);
        }
        if (!InputValidator.isHash(trunkTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isHash(branchTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid trytes provided.");
        }
        IotaAttachToTangleRequest attachToTangleRequest = IotaAttachToTangleRequest.createAttachToTangleRequest(trunkTransaction, branchTransaction, minWeightMagnitude, trytes);
        return this.getNodeFor(IotaAPICommand.ATTACH_TO_TANGLE).attachToTangle(attachToTangleRequest);
    }

    @Document
    public GetAttachToTangleResponse attachToTangleLocalPow(String trunkTransaction, String branchTransaction, Integer minWeightMagnitude, IotaPoW pow, String ... trytes) {
        if (pow == null) {
            log.warn("Called local POW without POW defined, switching to remote POW");
            return this.attachToTangle(trunkTransaction, branchTransaction, minWeightMagnitude, trytes);
        }
        if (!InputValidator.isHash(trunkTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isHash(branchTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid trytes provided.");
        }
        String[] resultTrytes = new String[trytes.length];
        String previousTransaction = null;
        try {
            int i = 0;
            while (i < resultTrytes.length) {
                Transaction txn = new Transaction(trytes[i]);
                txn.setTrunkTransaction(previousTransaction == null ? trunkTransaction : previousTransaction);
                txn.setBranchTransaction(previousTransaction == null ? branchTransaction : trunkTransaction);
                if (txn.getTag().isEmpty() || txn.getTag().matches("9*")) {
                    txn.setTag(txn.getObsoleteTag());
                }
                txn.setAttachmentTimestamp(System.currentTimeMillis());
                txn.setAttachmentTimestampLowerBound(0L);
                txn.setAttachmentTimestampUpperBound(3812798742493L);
                resultTrytes[i] = pow.performPoW(txn.toTrytes(), minWeightMagnitude);
                previousTransaction = new Transaction(resultTrytes[i], SpongeFactory.create(SpongeFactory.Mode.CURL_P81)).getHash();
                ++i;
            }
            Collections.reverse(Arrays.asList(resultTrytes));
        }
        catch (Exception e) {
            throw new ArgumentException("Could not compute PoW trytes", e);
        }
        return new GetAttachToTangleResponse(resultTrytes);
    }

    @Document
    public InterruptAttachingToTangleResponse interruptAttachingToTangle() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.INTERRUPT_ATTACHING_TO_TANGLE).interruptAttachingToTangle(IotaCommandRequest.createInterruptAttachToTangleRequest());
    }

    @Document
    public BroadcastTransactionsResponse broadcastTransactions(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfAttachedTrytes(trytes)) {
            throw new ArgumentException("Invalid attached trytes provided.");
        }
        return this.getNodeFor(IotaAPICommand.BROADCAST_TRANSACTIONS).broadcastTransactions(IotaBroadcastTransactionRequest.createBroadcastTransactionsRequest(trytes));
    }

    @Document
    public StoreTransactionsResponse storeTransactions(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfAttachedTrytes(trytes)) {
            throw new ArgumentException("Invalid attached trytes provided.");
        }
        return this.getNodeFor(IotaAPICommand.STORE_TRANSACTIONS).storeTransactions(IotaStoreTransactionsRequest.createStoreTransactionsRequest(trytes));
    }

    private void validateAddresses(String[] addresses) {
        if (ArrayUtils.isEmpty((Object[])addresses) || !InputValidator.isAddressesArrayValid(addresses)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
    }

    private String[] removeChecksumFromAddresses(String[] addresses) {
        String[] addressesWithoutChecksum = new String[addresses.length];
        int i = 0;
        while (i < addresses.length) {
            addressesWithoutChecksum[i] = Checksum.removeChecksum(addresses[i]);
            ++i;
        }
        return addressesWithoutChecksum;
    }

    private void validateTags(String[] tags) {
        if (!InputValidator.areValidTags(tags)) {
            throw new ArgumentException("Invalid tag provided.");
        }
    }

    private void validateBundles(String[] bundles) {
        if (!InputValidator.isArrayOfHashes(bundles)) {
            throw new ArgumentException("Invalid bundle hash.");
        }
    }

    private void validateApprovees(String[] bundles) {
        if (!InputValidator.isArrayOfHashes(bundles)) {
            throw new ArgumentException("Invalid bundle hash.");
        }
    }

    @Deprecated
    public String getProtocol() {
        return this.getNodeFor(null).url().getProtocol();
    }

    @Deprecated
    public String getHost() {
        return this.getNodeFor(null).url().getHost();
    }

    @Deprecated
    public String getPort() {
        return String.valueOf(this.getNodeFor(null).url().getPort());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("----------------------");
        builder.append(System.getProperty("line.separator"));
        builder.append(this.getOptions().toString());
        builder.append(System.getProperty("line.separator"));
        builder.append("Registered nodes: ");
        builder.append(System.getProperty("line.separator"));
        this.nodes.forEach(node -> {
            StringBuilder stringBuilder2 = builder.append(node.toString()).append(System.getProperty("line.separator"));
        });
        return builder.toString();
    }
}

