/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.iota.jota.account.PendingTransfer;
import org.iota.jota.account.deposits.StoredDepositAddress;

public class AccountState
implements Serializable {
    private static final long serialVersionUID = -8261579952650062417L;
    private int keyIndex;
    private Map<Integer, StoredDepositAddress> depositRequests;
    private Map<String, PendingTransfer> pendingTransfers;

    public AccountState() {
        this.pendingTransfers = new HashMap<String, PendingTransfer>();
        this.depositRequests = new HashMap<Integer, StoredDepositAddress>();
    }

    public AccountState(int keyIndex, Map<Integer, StoredDepositAddress> depositRequests, Map<String, PendingTransfer> pendingTransfers) {
        this.keyIndex = keyIndex;
        this.depositRequests = depositRequests;
        this.pendingTransfers = pendingTransfers;
    }

    public void addDepositRequest(int index, StoredDepositAddress request) {
        this.depositRequests.put(index, request);
    }

    public void removeDepositRequest(int index) {
        this.depositRequests.remove(index);
    }

    public void addPendingTransfers(String hash, PendingTransfer request) {
        this.pendingTransfers.put(hash, request);
    }

    public void removePendingTransfer(String hash) {
        this.pendingTransfers.remove(hash);
    }

    public boolean isNew() {
        return this.depositRequests.size() == 0 && this.pendingTransfers.size() == 0;
    }

    public Map<Integer, StoredDepositAddress> getDepositRequests() {
        return this.depositRequests;
    }

    public Map<String, PendingTransfer> getPendingTransfers() {
        return this.pendingTransfers;
    }

    public PendingTransfer getPendingTransfer(String hash) {
        return this.pendingTransfers.get(hash);
    }

    public AccountState clone() throws CloneNotSupportedException {
        AccountState newState = new AccountState();
        newState.keyIndex = this.keyIndex;
        if (null != this.depositRequests) {
            newState.depositRequests = new HashMap<Integer, StoredDepositAddress>();
            Iterator<Object> iterator = this.depositRequests.keySet().iterator();
            while (iterator.hasNext()) {
                int key = iterator.next();
                newState.depositRequests.put(key, this.depositRequests.get(key).clone());
            }
        }
        if (null != this.pendingTransfers) {
            newState.pendingTransfers = new HashMap<String, PendingTransfer>();
            for (String key : this.pendingTransfers.keySet()) {
                newState.pendingTransfers.put(key, this.pendingTransfers.get(key).clone());
            }
        }
        return newState;
    }

    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public String toString() {
        return "AccountState [keyIndex=" + this.keyIndex + ", depositRequests=" + this.depositRequests + ", pendingTransfers=" + this.pendingTransfers + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(AccountState.class)) {
            return false;
        }
        AccountState as = (AccountState)obj;
        return as.keyIndex == this.keyIndex && Objects.equals(this.depositRequests, as.depositRequests) && Objects.equals(this.pendingTransfers, as.pendingTransfers);
    }
}

