/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.store;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.Conventions;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;
import org.iota.jota.account.AccountState;
import org.iota.jota.account.ExportedAccountState;
import org.iota.jota.account.PendingTransfer;
import org.iota.jota.account.deposits.StoredDepositAddress;
import org.iota.jota.account.store.DatabaseStore;
import org.iota.jota.types.Hash;
import org.iota.jota.types.Trytes;
import org.iota.jota.utils.JsonParser;

public class MongoStore
extends DatabaseStore {
    private static final String PENDING = "pending_transfers";
    private static final String DEPOSIT = "deposit_requests";
    private static final String INDEX = "key_index";
    private static final String TAILS = "tail_hashes";
    private static final JsonWriterSettings settings = JsonWriterSettings.builder().int64Converter((value, writer) -> writer.writeNumber(value.toString())).dateTimeConverter((value, writer) -> writer.writeString(value + "")).build();
    private MongoClientOptions options;
    private List<MongoCredential> credentials;
    private ServerAddress address;
    private MongoClient client;
    private MongoCollection<Document> collection;
    private MongoDatabase database;
    private UpdateOptions updateOptions;

    public MongoStore() {
        this("iota_account", "accounts", "localhost", 27017);
    }

    public MongoStore(String databaseName) {
        this(databaseName, "accounts", "localhost", 27017);
    }

    public MongoStore(String databaseName, String tableName) {
        this(databaseName, tableName, "localhost", 27017);
    }

    public MongoStore(String databaseName, String tableName, String hostName) {
        this(databaseName, tableName, hostName, 27017);
    }

    public MongoStore(String databaseName, String tableName, URL databaseUrl) {
        this(databaseName, tableName, databaseUrl.getHost(), databaseUrl.getPort());
    }

    public MongoStore(String databaseName, String tableName, String hostName, int port) {
        super(databaseName, tableName);
        this.address = new ServerAddress(hostName, port);
        this.updateOptions = new UpdateOptions().upsert(true);
        LinkedList<SnakeConvention> conventions = new LinkedList<SnakeConvention>(Conventions.DEFAULT_CONVENTIONS);
        conventions.add(new SnakeConvention());
        PojoCodecProvider.Builder builder = PojoCodecProvider.builder();
        builder.register(new Class[]{StringAccountState.class});
        builder.conventions(conventions);
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().conventions(conventions).automatic(true).build()})});
        this.options = MongoClientOptions.builder().codecRegistry(codecRegistry).build();
    }

    public void addCredentials(String userName, String password) {
        this.addCredentials(userName, password, this.getDatabaseName());
    }

    public void addCredentials(String userName, String password, String database) {
        if (this.credentials == null) {
            this.credentials = new LinkedList<MongoCredential>();
        }
        this.credentials.add(MongoCredential.createCredential((String)userName, (String)database, (char[])password.toCharArray()));
    }

    public void setOptions(MongoClientOptions options) {
        this.options = options;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean start() {
        this.client = this.credentials != null ? new MongoClient(this.address, this.credentials, this.options) : new MongoClient(this.address, this.options);
        this.database = this.client.getDatabase(this.getDatabaseName());
        try {
            this.collection = this.database.getCollection(this.getTableName());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            try {
                this.database.createCollection(this.getTableName());
                this.collection = this.database.getCollection(this.getTableName());
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.collection = null;
        this.database = null;
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public AccountState loadAccount(String id) {
        AccountState accState;
        StringAccountState state = (StringAccountState)this.collection.find(Filters.eq((String)"_id", (Object)id), StringAccountState.class).projection(Projections.excludeId()).first();
        if (null == state) {
            accState = new AccountState();
            this.saveAccount(id, accState);
        } else {
            accState = state.toAccountState();
        }
        return accState;
    }

    @Override
    public void saveAccount(String id, AccountState state) {
        Document doc = new Document(id, (Object)new StringAccountState(state));
        UpdateResult result = this.collection.replaceOne(Filters.eq((String)"_id", (Object)id), (Object)doc, this.updateOptions);
        if (!result.isModifiedCountAvailable() || result.getModifiedCount() == 0L) {
            // empty if block
        }
    }

    @Override
    public void removeAccount(String id) {
        DeleteResult result = this.collection.deleteOne(Filters.eq((String)"_id", (Object)id));
        if (result.getDeletedCount() == 0L) {
            // empty if block
        }
    }

    @Override
    public int readIndex(String id) {
        Document index = (Document)this.collection.find(Filters.eq((String)"_id", (Object)id)).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{INDEX})})).first();
        return index != null && index.containsKey((Object)INDEX) ? index.getInteger((Object)INDEX) : -1;
    }

    @Override
    public void writeIndex(String id, int index) {
        UpdateResult result = this.collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)new Document("$set", (Object)new Document(INDEX, (Object)index)), this.updateOptions);
        if (!result.isModifiedCountAvailable() || result.getModifiedCount() == 0L) {
            // empty if block
        }
    }

    @Override
    public void addDepositAddress(String id, int index, StoredDepositAddress request) {
        UpdateResult result = this.collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)new Document("$set", (Object)new Document(DEPOSIT, (Object)new Document(index + "", (Object)request))), this.updateOptions);
        if (result == null) {
            // empty if block
        }
    }

    @Override
    public void removeDepositAddress(String id, int index) {
        UpdateResult result = this.collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)new Document("$unset", (Object)new Document(DEPOSIT, (Object)new Document(index + "", (Object)""))), this.updateOptions);
        if (result == null) {
            // empty if block
        }
    }

    @Override
    public Map<Integer, StoredDepositAddress> getDepositAddresses(String id) {
        Document requests = (Document)this.collection.find(Filters.eq((String)"_id", (Object)id)).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{DEPOSIT})})).first();
        HashMap<Integer, StoredDepositAddress> deposits = null;
        if (requests != null) {
            Map strDeposits = (Map)requests.get((Object)DEPOSIT, Map.class);
            deposits = new HashMap<Integer, StoredDepositAddress>();
            if (strDeposits != null) {
                for (Map.Entry entry : strDeposits.entrySet()) {
                    BsonDocument store = ((Document)entry.getValue()).toBsonDocument(StoredDepositAddress.class, this.collection.getCodecRegistry());
                    try {
                        StoredDepositAddress dep = (StoredDepositAddress)JsonParser.get().getObjectMapper().readValue(store.toJson(settings), StoredDepositAddress.class);
                        deposits.put(Integer.valueOf((String)entry.getKey()), dep);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return deposits;
    }

    @Override
    public void addPendingTransfer(String id, Hash tailTx, Trytes[] bundleTrytes, int ... indices) {
        PendingTransfer transfer = new PendingTransfer(super.trytesToTrits(bundleTrytes));
        transfer.addTail(tailTx);
        UpdateResult result = this.collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)new Document("$set", (Object)new Document(PENDING, (Object)new Document(tailTx.getHash(), (Object)transfer))), this.updateOptions);
        if (!result.isModifiedCountAvailable() || result.getModifiedCount() == 0L) {
            // empty if block
        }
    }

    @Override
    public void removePendingTransfer(String id, Hash tailHash) {
        UpdateResult result = this.collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)new Document("$unset", (Object)new Document(PENDING, (Object)new Document(tailHash.getHash(), (Object)""))), this.updateOptions);
        if (result == null) {
            // empty if block
        }
    }

    @Override
    public void addTailHash(String id, Hash tailHash, Hash newTailTxHash) {
        UpdateResult result = this.collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)new Document("$push", (Object)new Document("pending_transfers." + tailHash.getHash() + "." + TAILS, (Object)newTailTxHash)), this.updateOptions);
        if (result == null) {
            // empty if block
        }
    }

    @Override
    public Map<String, PendingTransfer> getPendingTransfers(String id) {
        Document requests = (Document)this.collection.find(Filters.eq((String)"_id", (Object)id)).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{PENDING})})).first();
        Map requestsMap = (Map)requests.get((Object)PENDING, Map.class);
        HashMap<String, PendingTransfer> pendingTransfers = new HashMap<String, PendingTransfer>();
        if (requestsMap != null) {
            for (Map.Entry entry : requestsMap.entrySet()) {
                BsonDocument store = ((Document)entry.getValue()).toBsonDocument(PendingTransfer.class, this.collection.getCodecRegistry());
                try {
                    PendingTransfer dep = (PendingTransfer)JsonParser.get().getObjectMapper().readValue(store.toJson(settings), PendingTransfer.class);
                    pendingTransfers.put((String)entry.getKey(), dep);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return pendingTransfers;
    }

    @Override
    public void importAccount(ExportedAccountState state) {
        this.saveAccount(state.getId(), state.getState());
    }

    @Override
    public ExportedAccountState exportAccount(String id) {
        AccountState state = this.loadAccount(id);
        return new ExportedAccountState(new Date(), id, state);
    }

    public MongoCollection<Document> getCollection() {
        return this.collection;
    }

    private class StringAccountState {
        int keyIndex;
        Map<String, PendingTransfer> pendingTransfers;
        Map<String, StoredDepositAddress> depositRequests;

        public StringAccountState(AccountState state) {
            this.keyIndex = state.getKeyIndex();
            this.pendingTransfers = state.getPendingTransfers();
            this.depositRequests = new HashMap<String, StoredDepositAddress>();
            for (Map.Entry<Integer, StoredDepositAddress> entry : state.getDepositRequests().entrySet()) {
                this.depositRequests.put(entry.getKey() + "", entry.getValue());
            }
        }

        public AccountState toAccountState() {
            HashMap<Integer, StoredDepositAddress> depositRequests = new HashMap<Integer, StoredDepositAddress>();
            for (Map.Entry<String, StoredDepositAddress> entry : this.depositRequests.entrySet()) {
                depositRequests.put(Integer.valueOf(entry.getKey()), entry.getValue());
            }
            return new AccountState(this.keyIndex, depositRequests, this.pendingTransfers);
        }
    }

    private class SnakeConvention
    implements Convention {
        private SnakeConvention() {
        }

        public void apply(ClassModelBuilder<?> classModelBuilder) {
            for (PropertyModelBuilder fieldModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
                fieldModelBuilder.discriminatorEnabled(false);
                fieldModelBuilder.readName(fieldModelBuilder.getName().replaceAll("([^_A-Z])([A-Z])", "$1_$2").toLowerCase());
                fieldModelBuilder.writeName(fieldModelBuilder.getName().replaceAll("([^_A-Z])([A-Z])", "$1_$2").toLowerCase());
            }
        }
    }
}

