/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.config.types;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.iota.jota.account.AccountStore;
import org.iota.jota.account.store.AccountFileStore;
import org.iota.jota.config.IotaClientConfig;
import org.iota.jota.connection.Connection;
import org.iota.jota.connection.HttpConnector;

public class IotaDefaultConfig
extends IotaClientConfig {
    @Override
    public int getLegacyPort() {
        return 14265;
    }

    @Override
    public String getLegacyProtocol() {
        return "http";
    }

    @Override
    public String getLegacyHost() {
        return "localhost";
    }

    @Override
    public AccountStore getStore() {
        return Defaults.STORE;
    }

    @Override
    public int getMwm() {
        return 14;
    }

    @Override
    public int getDepth() {
        return 3;
    }

    @Override
    public int getSecurityLevel() {
        return 3;
    }

    @Override
    public int getConnectionTimeout() {
        return 500;
    }

    @Override
    public List<Connection> getNodes() {
        ArrayList<Connection> list = new ArrayList<Connection>();
        try {
            list.add(new HttpConnector(this.getLegacyProtocol(), this.getLegacyHost(), this.getLegacyPort(), this.getConnectionTimeout()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return list;
    }

    public static class Defaults {
        public static final AccountStore STORE = new AccountFileStore();
        public static final int CONNECTION_TIMEOUT = 500;
        public static final int SECURITY_LEVEL = 3;
        public static final int DEPTH = 3;
        public static final int MWM = 14;
        public static final int LEGACY_PORT = 14265;
        public static final String LEGACY_PROTOCOL = "http";
        public static final String LEGACY_HOST = "localhost";
        public static final String DATABASE_NAME = "iota_account";
        public static final String TABLE_NAME = "accounts";
    }
}

