/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.iota.jota.model.Transaction;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.Signing;
import org.iota.jota.utils.TrytesConverter;

public class Bundle
implements Comparable<Bundle> {
    @Deprecated
    public static final String EMPTY_HASH = "999999999999999999999999999999999999999999999999999999999999999999999999999999999";
    private List<Transaction> transactions;
    private int length;

    public Bundle() {
        this(new ArrayList<Transaction>(), 0);
    }

    public Bundle(List<Transaction> transactions) {
        this(transactions, transactions.size());
    }

    public Bundle(List<Transaction> transactions, int length) {
        this.transactions = transactions;
        this.length = length;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getBundleHash() {
        if (this.getLength() == 0) {
            return EMPTY_HASH;
        }
        return this.transactions.get(0).getBundle();
    }

    public String getMessage() {
        StringBuilder str = new StringBuilder();
        for (Transaction t : this.getTransactions()) {
            if (t.getValue() != 0L) continue;
            str.append(t.getSignatureFragments());
        }
        if (str.length() % 2 != 0) {
            str.deleteCharAt(str.length() - 1);
        }
        return TrytesConverter.trytesToAscii(str.toString());
    }

    public void addTransaction(Transaction transaction) {
        if (this.getTransactions() == null) {
            this.transactions = new ArrayList<Transaction>(this.getTransactions());
        }
        this.transactions.add(transaction);
    }

    public void addEntry(int signatureMessageLength, String address, long value, String tag, long timestamp) {
        if (this.getTransactions() == null) {
            this.transactions = new ArrayList<Transaction>(this.getTransactions());
        }
        for (int i = 0; i < signatureMessageLength; ++i) {
            Transaction trx = new Transaction(address, i == 0 ? value : 0L, tag, timestamp);
            this.transactions.add(trx);
        }
    }

    public void finalize(ICurl customCurl) {
        String hashInTrytes;
        int i;
        boolean foundValue;
        int[] hash = new int[243];
        int[] obsoleteTagTrits = new int[81];
        boolean valid = true;
        ICurl curl = customCurl == null ? SpongeFactory.create(SpongeFactory.Mode.KERL) : customCurl;
        do {
            curl.reset();
            for (i = 0; i < this.getTransactions().size(); ++i) {
                int[] valueTrits = Converter.trits(this.getTransactions().get(i).getValue(), 81);
                int[] timestampTrits = Converter.trits(this.getTransactions().get(i).getTimestamp(), 27);
                this.getTransactions().get(i).setCurrentIndex(i);
                int[] currentIndexTrits = Converter.trits(this.getTransactions().get(i).getCurrentIndex(), 27);
                this.getTransactions().get(i).setLastIndex(this.getTransactions().size() - 1);
                int[] lastIndexTrits = Converter.trits(this.getTransactions().get(i).getLastIndex(), 27);
                int[] t = Converter.trits(this.getTransactions().get(i).getAddress().substring(0, 81) + Converter.trytes(valueTrits) + this.getTransactions().get(i).getObsoleteTag() + Converter.trytes(timestampTrits) + Converter.trytes(currentIndexTrits) + Converter.trytes(lastIndexTrits));
                curl.absorb(t, 0, t.length);
            }
            curl.squeeze(hash, 0, hash.length);
            hashInTrytes = Converter.trytes(hash);
            int[] normalizedBundleValue = this.normalizedBundle(hashInTrytes);
            foundValue = false;
            for (int aNormalizedBundleValue : normalizedBundleValue) {
                if (aNormalizedBundleValue != 13) continue;
                foundValue = true;
                obsoleteTagTrits = Converter.trits(this.getTransactions().get(0).getObsoleteTag());
                Converter.increment(obsoleteTagTrits, 81);
                this.getTransactions().get(0).setObsoleteTag(Converter.trytes(obsoleteTagTrits));
            }
        } while (!(valid = !foundValue));
        for (i = 0; i < this.getTransactions().size(); ++i) {
            this.getTransactions().get(i).setBundle(hashInTrytes);
        }
    }

    public void addTrytes(List<String> signatureFragments) {
        String emptySignatureFragment = "";
        String emptyHash = EMPTY_HASH;
        long emptyTimestamp = 999999999L;
        emptySignatureFragment = StringUtils.rightPad((String)emptySignatureFragment, (int)2187, (char)'9');
        for (int i = 0; i < this.getTransactions().size(); ++i) {
            Transaction t = this.getTransactions().get(i);
            t.setSignatureFragments(signatureFragments.size() <= i || signatureFragments.get(i).isEmpty() ? emptySignatureFragment : signatureFragments.get(i));
            t.setTrunkTransaction(emptyHash);
            t.setBranchTransaction(emptyHash);
            t.setAttachmentTimestamp(emptyTimestamp);
            t.setAttachmentTimestampLowerBound(emptyTimestamp);
            t.setAttachmentTimestampUpperBound(emptyTimestamp);
            t.setNonce(StringUtils.rightPad((String)"", (int)27, (String)"9"));
        }
    }

    @Deprecated
    public int[] normalizedBundle(String bundleHash) {
        return this.normalizedBundle(bundleHash, SpongeFactory.create(SpongeFactory.Mode.KERL));
    }

    public int[] normalizedBundle(String bundleHash, ICurl curl) {
        return new Signing(curl).normalizedBundle(bundleHash);
    }

    @Override
    public int compareTo(Bundle o) {
        return Long.compare(this.getTransactions().get(0).getAttachmentTimestamp(), o.getTransactions().get(0).getAttachmentTimestamp());
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

