/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.math.NumberUtils;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Input;
import org.iota.jota.model.Transfer;
import org.iota.jota.utils.Converter;

public class InputValidator {
    public static boolean isAddress(String address) {
        return address.length() == 90 && InputValidator.isTrytes(address);
    }

    public static boolean isAddressWithoutChecksum(String address) {
        return InputValidator.isTrytes(address, 81);
    }

    public static boolean hasTrailingZeroTrit(String trytes) {
        int[] trits = Converter.trits(trytes);
        return trits[trits.length - 1] == 0;
    }

    public static boolean isAddressesCollectionValid(List<String> addresses) throws ArgumentException {
        for (String address : addresses) {
            if (InputValidator.checkAddress(address)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAddressesArrayValid(String[] addresses) throws ArgumentException {
        for (String address : addresses) {
            if (InputValidator.checkAddress(address)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAddress(String address) throws ArgumentException {
        if (!InputValidator.isAddress(address)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        return true;
    }

    public static boolean checkAddressWithoutChecksum(String address) throws ArgumentException {
        if (!InputValidator.isTrytes(address, 81)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        return true;
    }

    public static boolean isTrytes(String trytes) {
        return InputValidator.isTrytes(trytes, trytes.length());
    }

    public static boolean isTrytesOfExactLength(String trytes, int length) {
        return trytes.matches("^[A-Z9]{" + (length == 0 ? "0," : length + ",") + "}$");
    }

    public static boolean isTrytes(String trytes, int length) {
        return InputValidator.isTrytesOfExactLength(trytes, length);
    }

    public static boolean isNinesTrytes(String trytes, int length) {
        return trytes.matches("^[9]{" + (length == 0 ? "0," : length + ",") + "}$");
    }

    public static boolean isValue(String value) {
        return NumberUtils.isCreatable((String)value);
    }

    public static boolean isArrayOfTrytes(String[] trytes) {
        return InputValidator.isArrayOfTrytes(trytes, 2673);
    }

    public static boolean isArrayOfRawTransactionTrytes(String[] trytes) {
        for (String tr : trytes) {
            if (InputValidator.isNinesTrytes(tr.substring(2279, 2295), 16)) continue;
            return false;
        }
        return InputValidator.isArrayOfTrytes(trytes, 2673);
    }

    public static boolean isArrayOfTrytes(String[] trytes, int length) {
        for (String tryte : trytes) {
            if (InputValidator.isTrytes(tryte, length)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStringArrayValid(String[] data) {
        return null != data && 0 != data.length;
    }

    public static boolean isTransfersCollectionValid(List<Transfer> transfers) throws ArgumentException {
        if (transfers == null || transfers.isEmpty()) {
            throw new ArgumentException("Invalid transfers provided.");
        }
        for (Transfer transfer : transfers) {
            if (InputValidator.isValidTransfer(transfer)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidTransfer(Transfer transfer) {
        if (transfer == null) {
            return false;
        }
        if (!InputValidator.isAddress(transfer.getAddress())) {
            return false;
        }
        if (transfer.getMessage() == null || !InputValidator.isTrytes(transfer.getMessage(), transfer.getMessage().length())) {
            return false;
        }
        return InputValidator.isTag(transfer.getTag());
    }

    public static boolean isTag(String tag) {
        return InputValidator.isValidTag(tag);
    }

    public static boolean isValidTag(String tag) {
        return tag != null && tag.length() <= 27 && InputValidator.isTrytes(tag);
    }

    public static boolean areValidTags(String ... tags) {
        for (String tag : tags) {
            if (InputValidator.isValidTag(tag)) continue;
            return false;
        }
        return true;
    }

    public static boolean areValidInputsList(List<Input> inputs) {
        return InputValidator.areValidInputs(inputs.toArray(new Input[inputs.size()]));
    }

    public static boolean areValidInputs(Input ... inputs) {
        if (inputs == null || inputs.length == 0) {
            return false;
        }
        for (Input input : inputs) {
            if (InputValidator.isValidInput(input)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidInput(Input input) {
        if (input == null) {
            return false;
        }
        if (!InputValidator.isAddress(input.getAddress())) {
            return false;
        }
        if (input.getKeyIndex() < 0) {
            return false;
        }
        return InputValidator.isValidSecurityLevel(input.getSecurity());
    }

    public static boolean isValidSeed(String seed) {
        return seed.length() <= 81 && InputValidator.isTrytes(seed);
    }

    public static String requireValidSeed(String seed) {
        if (InputValidator.isValidSeed(seed)) {
            return seed;
        }
        throw new IllegalArgumentException("Provided seed is invalid.");
    }

    public static boolean isArrayOfHashes(String[] hashes) {
        if (hashes == null) {
            return false;
        }
        for (String hash : hashes) {
            if (InputValidator.isHash(hash)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHashes(List<String> hashes) {
        if (null == hashes) {
            return false;
        }
        for (String hash : hashes) {
            if (InputValidator.isHash(hash)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHash(String hash) {
        return !(hash.length() == 90 ? !InputValidator.isTrytes(hash, 90) : !InputValidator.isTrytes(hash, 81));
    }

    public static boolean isArrayOfAttachedTrytes(String[] trytes) {
        for (String tryteValue : trytes) {
            if (!InputValidator.isTrytes(tryteValue, 2673)) {
                return false;
            }
            String lastTrytes = tryteValue.substring(2430);
            if (!InputValidator.isNinesTrytes(lastTrytes, lastTrytes.length())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSecurityLevel(int level) {
        return level >= 1 && level <= 3;
    }

    public static int requireValidSecurityLevel(int securityLevel) {
        if (InputValidator.isValidSecurityLevel(securityLevel)) {
            return securityLevel;
        }
        throw new IllegalArgumentException("Value is not within the specified security level range");
    }

    public static boolean isTrits(int[] trits) {
        Range myRange = Range.between((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(1));
        IntPredicate contains = arg_0 -> ((Range)myRange).contains(arg_0);
        long min = Arrays.stream(trits).filter(contains.negate()).count();
        return min == 0L;
    }

    public static boolean isTrits(List<Integer> trits) {
        Range myRange = Range.between((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(1));
        IntPredicate contains = arg_0 -> ((Range)myRange).contains(arg_0);
        long min = trits.stream().filter(integer -> contains.negate().test((int)integer)).count();
        return min == 0L;
    }
}

