/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import java.text.DecimalFormat;
import org.iota.jota.utils.IotaUnits;

public class IotaUnitConverter {
    public static long convertUnits(long amount, IotaUnits fromUnit, IotaUnits toUnit) {
        long amountInSource = (long)((double)amount * Math.pow(10.0, fromUnit.getValue()));
        return IotaUnitConverter.convertUnits(amountInSource, toUnit);
    }

    private static long convertUnits(long amount, IotaUnits toUnit) {
        return (long)((double)amount / Math.pow(10.0, toUnit.getValue()));
    }

    public static String convertRawIotaAmountToDisplayText(long amount, boolean extended) {
        IotaUnits unit = IotaUnitConverter.findOptimalIotaUnitToDisplay(amount);
        double amountInDisplayUnit = IotaUnitConverter.convertAmountTo(amount, unit);
        return IotaUnitConverter.createAmountWithUnitDisplayText(amountInDisplayUnit, unit, extended);
    }

    public static double convertAmountTo(long amount, IotaUnits target) {
        return (double)amount / Math.pow(10.0, target.getValue());
    }

    private static String createAmountWithUnitDisplayText(double amountInUnit, IotaUnits unit, boolean extended) {
        String result = IotaUnitConverter.createAmountDisplayText(amountInUnit, unit, extended);
        result = result + " " + unit.getUnit();
        return result;
    }

    public static String createAmountDisplayText(double amountInUnit, IotaUnits unit, boolean extended) {
        DecimalFormat df = extended ? new DecimalFormat("##0.##################") : new DecimalFormat("##0.##");
        String result = "";
        result = result + (unit == IotaUnits.IOTA ? Long.valueOf((long)amountInUnit) : df.format(amountInUnit));
        return result;
    }

    public static IotaUnits findOptimalIotaUnitToDisplay(long amount) {
        int length = String.valueOf(amount).length();
        if (amount < 0L) {
            --length;
        }
        IotaUnits units = IotaUnits.IOTA;
        if (length >= 1 && length <= 3) {
            units = IotaUnits.IOTA;
        } else if (length > 3 && length <= 6) {
            units = IotaUnits.KILO_IOTA;
        } else if (length > 6 && length <= 9) {
            units = IotaUnits.MEGA_IOTA;
        } else if (length > 9 && length <= 12) {
            units = IotaUnits.GIGA_IOTA;
        } else if (length > 12 && length <= 15) {
            units = IotaUnits.TERA_IOTA;
        } else if (length > 15 && length <= 18) {
            units = IotaUnits.PETA_IOTA;
        }
        return units;
    }
}

