/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.cli.internal.Command;
import org.jacoco.cli.internal.args4j.Argument;
import org.jacoco.cli.internal.args4j.Option;
import org.jacoco.cli.internal.core.instr.Instrumenter;
import org.jacoco.cli.internal.core.runtime.OfflineInstrumentationAccessGenerator;

public class Instrument
extends Command {
    @Option(name="--dest", usage="path to write instrumented Java classes to", metaVar="<dir>", required=true)
    File dest;
    @Argument(usage="list of folder or files to instrument recusively", metaVar="<sourcefiles>")
    List<File> source = new ArrayList<File>();
    private Instrumenter instrumenter;

    public String description() {
        return "Off-line instrumentation of Java class files and JAR files.";
    }

    public int execute(PrintWriter out, PrintWriter err) throws IOException {
        File absoluteDest = this.dest.getAbsoluteFile();
        this.instrumenter = new Instrumenter(new OfflineInstrumentationAccessGenerator());
        int total = 0;
        for (File s : this.source) {
            if (s.isFile()) {
                total += this.instrument(s, new File(absoluteDest, s.getName()));
                continue;
            }
            total += this.instrumentRecursive(s, absoluteDest);
        }
        out.printf("[INFO] %s classes instrumented to %s.%n", total, absoluteDest);
        return 0;
    }

    private int instrumentRecursive(File src, File dest) throws IOException {
        int total = 0;
        if (src.isDirectory()) {
            for (File child : src.listFiles()) {
                total += this.instrumentRecursive(child, new File(dest, child.getName()));
            }
        } else {
            total += this.instrument(src, dest);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int instrument(File src, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        FileInputStream input = new FileInputStream(src);
        try {
            int n;
            FileOutputStream output = new FileOutputStream(dest);
            try {
                n = this.instrumenter.instrumentAll(input, output, src.getAbsolutePath());
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)output).close();
                    throw throwable;
                }
                catch (IOException e) {
                    dest.delete();
                    throw e;
                }
            }
            ((OutputStream)output).close();
            return n;
        }
        finally {
            ((InputStream)input).close();
        }
    }
}

