/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import java.util.HashMap;
import java.util.Map;
import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.JumpInsnNode;
import org.jacoco.cli.internal.asm.tree.LabelNode;
import org.jacoco.cli.internal.asm.tree.MethodInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.asm.tree.TryCatchBlockNode;
import org.jacoco.cli.internal.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilter;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterContext;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;

final class TryWithResourcesEcjFilter
implements IFilter {
    TryWithResourcesEcjFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return;
        }
        Matcher matcher = new Matcher(output);
        for (TryCatchBlockNode t : methodNode.tryCatchBlocks) {
            if (t.type != null) continue;
            matcher.start(t.handler);
            if (matcher.matchEcj()) continue;
            matcher.start(t.handler);
            matcher.matchEcjNoFlowOut();
        }
    }

    static class Matcher
    extends AbstractMatcher {
        private final IFilterOutput output;
        private final Map<String, String> owners = new HashMap<String, String>();
        private final Map<String, LabelNode> labels = new HashMap<String, LabelNode>();
        private AbstractInsnNode start;

        Matcher(IFilterOutput output) {
            this.output = output;
        }

        private void start(AbstractInsnNode start) {
            this.start = start;
            this.cursor = start.getPrevious();
            this.vars.clear();
            this.labels.clear();
            this.owners.clear();
        }

        private boolean matchEcj() {
            AbstractInsnNode startOnNonExceptionalPath;
            this.nextIsVar(58, "primaryExc");
            this.nextIsEcjCloseAndThrow("r0");
            int resources = 1;
            String r = "r" + resources;
            AbstractInsnNode c = this.cursor;
            while (this.nextIsEcjClose(r)) {
                this.nextIsJump(167, r + ".end");
                this.nextIsEcjSuppress(r);
                this.nextIsEcjCloseAndThrow(r);
                r = "r" + ++resources;
                c = this.cursor;
            }
            this.cursor = c;
            this.nextIsEcjSuppress("last");
            this.nextIsVar(25, "primaryExc");
            this.nextIs(191);
            if (this.cursor == null) {
                return false;
            }
            AbstractInsnNode end = this.cursor;
            this.cursor = startOnNonExceptionalPath = this.start.getPrevious();
            while (!this.nextIsEcjClose("r0")) {
                this.cursor = startOnNonExceptionalPath = startOnNonExceptionalPath.getPrevious();
                if (this.cursor != null) continue;
                return false;
            }
            startOnNonExceptionalPath = startOnNonExceptionalPath.getNext();
            this.next();
            if (this.cursor == null || this.cursor.getOpcode() != 167) {
                return false;
            }
            this.output.ignore(startOnNonExceptionalPath, this.cursor);
            this.output.ignore(this.start, end);
            return true;
        }

        private boolean matchEcjNoFlowOut() {
            AbstractInsnNode startOnNonExceptionalPath;
            this.nextIsVar(58, "primaryExc");
            int resources = 0;
            String r = "r" + resources;
            AbstractInsnNode c = this.cursor;
            while (this.nextIsEcjCloseAndThrow(r) && this.nextIsEcjSuppress(r)) {
                r = "r" + ++resources;
                c = this.cursor;
            }
            this.cursor = c;
            this.nextIsVar(25, "primaryExc");
            this.nextIs(191);
            if (this.cursor == null) {
                return false;
            }
            AbstractInsnNode end = this.cursor;
            this.cursor = startOnNonExceptionalPath = this.start.getPrevious();
            while (!this.nextIsEcjClose("r0")) {
                this.cursor = startOnNonExceptionalPath = startOnNonExceptionalPath.getPrevious();
                if (this.cursor != null) continue;
                return false;
            }
            startOnNonExceptionalPath = startOnNonExceptionalPath.getNext();
            for (int i = 1; i < resources; ++i) {
                if (this.nextIsEcjClose("r" + i)) continue;
                return false;
            }
            this.output.ignore(startOnNonExceptionalPath, this.cursor);
            this.output.ignore(this.start, end);
            return true;
        }

        private boolean nextIsEcjClose(String name) {
            this.nextIsVar(25, name);
            this.nextIsJump(198, name + ".end");
            this.nextIsClose(name);
            return this.cursor != null;
        }

        private boolean nextIsEcjCloseAndThrow(String name) {
            this.nextIsVar(25, name);
            this.nextIsJump(198, name);
            this.nextIsClose(name);
            this.nextIsLabel(name);
            this.nextIsVar(25, "primaryExc");
            this.nextIs(191);
            return this.cursor != null;
        }

        private boolean nextIsEcjSuppress(String name) {
            String suppressedExc = name + ".t";
            String startLabel = name + ".suppressStart";
            String endLabel = name + ".suppressEnd";
            this.nextIsVar(58, suppressedExc);
            this.nextIsVar(25, "primaryExc");
            this.nextIsJump(199, startLabel);
            this.nextIsVar(25, suppressedExc);
            this.nextIsVar(58, "primaryExc");
            this.nextIsJump(167, endLabel);
            this.nextIsLabel(startLabel);
            this.nextIsVar(25, "primaryExc");
            this.nextIsVar(25, suppressedExc);
            this.nextIsJump(165, endLabel);
            this.nextIsVar(25, "primaryExc");
            this.nextIsVar(25, suppressedExc);
            this.nextIsInvoke(182, "java/lang/Throwable", "addSuppressed", "(Ljava/lang/Throwable;)V");
            this.nextIsLabel(endLabel);
            return this.cursor != null;
        }

        private void nextIsClose(String name) {
            this.nextIsVar(25, name);
            this.next();
            if (this.cursor == null) {
                return;
            }
            if (this.cursor.getOpcode() != 185 && this.cursor.getOpcode() != 182) {
                this.cursor = null;
                return;
            }
            MethodInsnNode m = (MethodInsnNode)this.cursor;
            if (!"close".equals(m.name) || !"()V".equals(m.desc)) {
                this.cursor = null;
                return;
            }
            String actual = m.owner;
            String expected = this.owners.get(name);
            if (expected == null) {
                this.owners.put(name, actual);
            } else if (!expected.equals(actual)) {
                this.cursor = null;
            }
        }

        private void nextIsJump(int opcode, String name) {
            this.nextIs(opcode);
            if (this.cursor == null) {
                return;
            }
            LabelNode actual = ((JumpInsnNode)this.cursor).label;
            LabelNode expected = this.labels.get(name);
            if (expected == null) {
                this.labels.put(name, actual);
            } else if (expected != actual) {
                this.cursor = null;
            }
        }

        private void nextIsLabel(String name) {
            if (this.cursor == null) {
                return;
            }
            this.cursor = this.cursor.getNext();
            if (this.cursor.getType() != 8) {
                this.cursor = null;
                return;
            }
            LabelNode actual = (LabelNode)this.cursor;
            LabelNode expected = this.labels.get(name);
            if (expected != actual) {
                this.cursor = null;
            }
        }
    }
}

