/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.report.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.jacoco.cli.internal.core.analysis.IBundleCoverage;
import org.jacoco.cli.internal.core.data.ExecutionData;
import org.jacoco.cli.internal.core.data.SessionInfo;
import org.jacoco.cli.internal.report.IReportGroupVisitor;
import org.jacoco.cli.internal.report.IReportVisitor;
import org.jacoco.cli.internal.report.ISourceFileLocator;
import org.jacoco.cli.internal.report.internal.xml.ReportElement;
import org.jacoco.cli.internal.report.internal.xml.XMLCoverageWriter;
import org.jacoco.cli.internal.report.internal.xml.XMLGroupVisitor;

public class XMLFormatter {
    private String outputEncoding = "UTF-8";

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public IReportVisitor createVisitor(final OutputStream output) throws IOException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RootVisitor
        implements IReportVisitor {
            private ReportElement report;
            private List<SessionInfo> sessionInfos;
            private XMLGroupVisitor groupVisitor;

            RootVisitor() {
            }

            @Override
            public void visitInfo(List<SessionInfo> sessionInfos, Collection<ExecutionData> executionData) throws IOException {
                this.sessionInfos = sessionInfos;
            }

            @Override
            public void visitBundle(IBundleCoverage bundle, ISourceFileLocator locator) throws IOException {
                this.createRootElement(bundle.getName());
                XMLCoverageWriter.writeBundle(bundle, this.report);
            }

            @Override
            public IReportGroupVisitor visitGroup(String name) throws IOException {
                this.createRootElement(name);
                this.groupVisitor = new XMLGroupVisitor(this.report, name);
                return this.groupVisitor;
            }

            private void createRootElement(String name) throws IOException {
                this.report = new ReportElement(name, output, XMLFormatter.this.outputEncoding);
                for (SessionInfo i : this.sessionInfos) {
                    this.report.sessioninfo(i);
                }
            }

            @Override
            public void visitEnd() throws IOException {
                if (this.groupVisitor != null) {
                    this.groupVisitor.visitEnd();
                }
                this.report.close();
            }
        }
        return new RootVisitor();
    }
}

