/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Closeable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.javalite.activejdbc.ConnectionsAccess;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.RowListener;
import org.javalite.activejdbc.RowListenerAdapter;
import org.javalite.activejdbc.RowProcessor;
import org.javalite.activejdbc.StatementCache;
import org.javalite.activejdbc.connection_config.ConnectionConfig;
import org.javalite.activejdbc.connection_config.ConnectionDataSourceConfig;
import org.javalite.activejdbc.connection_config.ConnectionJdbcConfig;
import org.javalite.activejdbc.connection_config.ConnectionJndiConfig;
import org.javalite.activejdbc.connection_config.DBConfiguration;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.app_config.AppConfig;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DB.class);
    static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*SELECT", 10);
    static final Pattern INSERT_PATTERN = Pattern.compile("^\\s*INSERT", 10);
    public static final String DEFAULT_NAME = "default";
    private final String name;

    public DB(String name) {
        this.name = name;
    }

    public DB() {
        this.name = DEFAULT_NAME;
    }

    public String name() {
        return this.name;
    }

    public DB open(String driver, String url, String user, String password) {
        return this.open(driver, url, user, password, null);
    }

    public DB open(String driver, String url, Properties props) {
        return this.open(driver, url, null, null, props);
    }

    private DB open(String driver, String url, String user, String password, Properties properties) {
        this.checkExistingConnection(this.name);
        try {
            Class.forName(driver);
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Opening connection to URL: {}", (Object)url);
            Connection connection = properties == null ? DriverManager.getConnection(url, user, password) : DriverManager.getConnection(url, properties);
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Opened connection: {}, URL: {}", (Object)connection, (Object)url);
            ConnectionsAccess.attach(this.name, connection, url);
            return this;
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JDBC URL: " + url + " with user: " + user, e);
        }
    }

    public DB open(String jndiName) {
        this.checkExistingConnection(this.name);
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            Connection connection = ds.getConnection();
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Opened connection: {}, JNDI: {}", (Object)connection, (Object)jndiName);
            ConnectionsAccess.attach(this.name, connection, jndiName);
            return this;
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    public DB open() {
        List<ConnectionConfig> connectionConfigs = DBConfiguration.getConnectionConfigsExceptTesting(this.name);
        if (connectionConfigs.isEmpty()) {
            throw new DBException("Could not find configuration in a property file for environment: " + AppConfig.activeEnv() + ". Are you sure you called org.javalite.activejdbc.connection_config.DBConfiguration.loadConfiguration(\"/database.properties\") or similar? You can also call org.javalite.activejdbc.connection_config.DBConfiguration.addConnectionConfig(...) directly");
        }
        return this.open(connectionConfigs.get(0));
    }

    public void attach(Connection connection) {
        ConnectionsAccess.attach(this.name, connection, "");
    }

    public Connection detach() {
        Connection connection = ConnectionsAccess.getConnection(this.name);
        try {
            if (connection == null) {
                throw new DBException("cannot detach connection '" + this.name + "' because it is not available");
            }
            ConnectionsAccess.detach(this.name);
            StatementCache.instance().cleanStatementCache(connection);
        }
        catch (DBException e) {
            LogFilter.log(LOGGER, LogLevel.ERROR, "Could not close connection! MUST INVESTIGATE POTENTIAL CONNECTION LEAK!", (Object)e);
        }
        return connection;
    }

    public DB open(DataSource datasource) {
        this.checkExistingConnection(this.name);
        try {
            Connection connection = datasource.getConnection();
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Opened connection: " + connection);
            ConnectionsAccess.attach(this.name, connection, datasource.toString());
            return this;
        }
        catch (SQLException e) {
            throw new InitException(e);
        }
    }

    public DB open(String jndiName, Properties jndiProperties) {
        this.checkExistingConnection(this.name);
        try {
            InitialContext ctx = new InitialContext(jndiProperties);
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            Connection connection = ds.getConnection();
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Opened connection: {}, JNDI: {}", (Object)connection, (Object)jndiName);
            ConnectionsAccess.attach(this.name, connection, jndiProperties.contains("url") ? jndiProperties.getProperty("url") : jndiName);
            return this;
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    public DB open(ConnectionConfig config) {
        this.checkExistingConnection(this.name);
        if (config instanceof ConnectionJdbcConfig) {
            return this.openJdbc((ConnectionJdbcConfig)config);
        }
        if (config instanceof ConnectionJndiConfig) {
            return this.openJndi((ConnectionJndiConfig)config);
        }
        if (config instanceof ConnectionDataSourceConfig) {
            return this.openDataSource((ConnectionDataSourceConfig)config);
        }
        throw new IllegalArgumentException("this spec not supported: " + config.getClass());
    }

    private void checkExistingConnection(String name) {
        if (null != ConnectionsAccess.getConnection(name)) {
            throw new DBException("Cannot open a new connection because existing connection is still on current thread, name: " + name + ", connection instance: " + this.connection() + ". This might indicate a logical error in your application.");
        }
    }

    private DB openJdbc(ConnectionJdbcConfig config) {
        if (config.getProps() != null) {
            return this.open(config.getDriver(), config.getUrl(), config.getProps());
        }
        return this.open(config.getDriver(), config.getUrl(), config.getUser(), config.getPassword());
    }

    private DB openJndi(ConnectionJndiConfig config) {
        if (config.getContext() != null) {
            return this.openContext(config.getContext(), config.getDataSourceJndiName());
        }
        return this.open(config.getDataSourceJndiName());
    }

    private DB openDataSource(ConnectionDataSourceConfig config) {
        return this.open(config.getDataSource());
    }

    private DB openContext(InitialContext context, String jndiName) {
        try {
            DataSource ds = (DataSource)context.lookup(jndiName);
            Connection connection = ds.getConnection();
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Opened connection: {}, JNDI: ", (Object)connection, (Object)jndiName);
            ConnectionsAccess.attach(this.name, connection, jndiName);
            return this;
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean suppressWarning) {
        try {
            Connection connection = ConnectionsAccess.getConnection(this.name);
            if (connection == null) {
                throw new DBException("cannot close connection '" + this.name + "' because it is not available");
            }
            StatementCache.instance().cleanStatementCache(connection);
            connection.close();
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Closed connection: {}", (Object)connection);
        }
        catch (Exception e) {
            if (!suppressWarning) {
                LOGGER.warn("Could not close connection! MUST INVESTIGATE POTENTIAL CONNECTION LEAK!", (Throwable)e);
            }
        }
        finally {
            ConnectionsAccess.detach(this.name);
        }
    }

    public Long count(String table) {
        String sql = "SELECT COUNT(*) FROM " + table;
        return Convert.toLong((Object)this.firstCell(sql, new Object[0]));
    }

    public Long count(String table, String query, Object ... params) {
        if (query.trim().equals("*")) {
            if (Util.empty((Object[])params)) {
                return this.count(table);
            }
            throw new IllegalArgumentException("cannot use '*' and parameters");
        }
        String sql = "SELECT COUNT(*) FROM " + table + " WHERE " + query;
        return Convert.toLong((Object)this.firstCell(sql, params));
    }

    public Object firstCell(String query, Object ... params) {
        Object object;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Object result = null;
            long start = System.currentTimeMillis();
            ps = this.connection().prepareStatement(query);
            this.setParameters(ps, params);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1);
            }
            LogFilter.logQuery(LOGGER, query, params, start);
            object = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException(query, params, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(rs);
                Util.closeQuietly(ps);
                throw throwable;
            }
        }
        Util.closeQuietly((AutoCloseable)rs);
        Util.closeQuietly((AutoCloseable)ps);
        return object;
    }

    public List<Map> all(String query, Object ... params) {
        return this.findAll(query, params);
    }

    public List<Map> findAll(String query, Object ... params) {
        final ArrayList<Map> results = new ArrayList<Map>();
        long start = System.currentTimeMillis();
        this.find(query, params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                results.add(row);
            }
        });
        LogFilter.logQuery(LOGGER, query, params, start);
        return results;
    }

    public List firstColumn(String query, Object ... params) {
        ArrayList<Object> arrayList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            long start = System.currentTimeMillis();
            ps = this.connection().prepareStatement(query);
            this.setParameters(ps, params);
            rs = ps.executeQuery();
            while (rs.next()) {
                results.add(rs.getObject(1));
            }
            LogFilter.logQuery(LOGGER, query, params, start);
            arrayList = results;
        }
        catch (SQLException e) {
            try {
                throw new DBException(query, params, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(rs);
                Util.closeQuietly(ps);
                throw throwable;
            }
        }
        Util.closeQuietly((AutoCloseable)rs);
        Util.closeQuietly((AutoCloseable)ps);
        return arrayList;
    }

    public List<Map> all(String query) {
        return this.findAll(query);
    }

    public List<Map> findAll(String query) {
        final ArrayList<Map> results = new ArrayList<Map>();
        long start = System.currentTimeMillis();
        this.find(query, new Object[0]).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                results.add(row);
            }
        });
        LogFilter.logQuery(LOGGER, query, null, start);
        return results;
    }

    public RowProcessor find(String query, Object ... params) {
        return this.find(RowProcessor.ResultSetType.FORWARD_ONLY, RowProcessor.ResultSetConcur.READ_ONLY, 0, query, params);
    }

    public RowProcessor find(RowProcessor.ResultSetType type, RowProcessor.ResultSetConcur concur, int fetchSize, String query, Object ... params) {
        if (query.indexOf(63) == -1 && params.length != 0) {
            throw new IllegalArgumentException("you passed arguments, but the query does not have placeholders: (?)");
        }
        try {
            PreparedStatement ps = this.createStreamingPreparedStatement(query, type, concur, fetchSize);
            this.setParameters(ps, params);
            ResultSet rs = ps.executeQuery();
            return new RowProcessor(rs, ps);
        }
        catch (SQLException e) {
            throw new DBException(query, params, e);
        }
    }

    private PreparedStatement createStreamingPreparedStatement(String query, RowProcessor.ResultSetType type, RowProcessor.ResultSetConcur concur, int fetchSize) throws SQLException {
        Connection conn = this.connection();
        PreparedStatement res = conn.prepareStatement(query, type.getValue(), concur.getValue());
        res.setFetchSize(fetchSize);
        return res;
    }

    public void find(String sql, RowListener listener) {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = this.createStreamingStatement();
            rs = s.executeQuery(sql);
            RowProcessor p = new RowProcessor(rs, s);
            p.with(listener);
        }
        catch (SQLException e) {
            try {
                throw new DBException(sql, null, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(rs);
                Util.closeQuietly((AutoCloseable)s);
                throw throwable;
            }
        }
        Util.closeQuietly((AutoCloseable)rs);
        Util.closeQuietly((AutoCloseable)s);
    }

    private Statement createStreamingStatement() throws SQLException {
        Statement res;
        Connection conn = this.connection();
        if ("mysql".equalsIgnoreCase(conn.getMetaData().getDatabaseProductName())) {
            res = conn.createStatement(1003, 1007);
            res.setFetchSize(Integer.MIN_VALUE);
        } else {
            res = conn.createStatement();
        }
        return res;
    }

    public int exec(String query) {
        long start = System.currentTimeMillis();
        Statement s = null;
        try {
            s = this.connection().createStatement();
            int count = s.executeUpdate(query);
            LogFilter.logQuery(LOGGER, query, null, start);
            int n = count;
            return n;
        }
        catch (SQLException e) {
            this.logException("Query failed: " + query, e);
            throw new DBException(query, null, e);
        }
        finally {
            Util.closeQuietly((AutoCloseable)s);
        }
    }

    public int exec(String query, Object ... params) {
        int n;
        if (query.indexOf(63) == -1) {
            throw new IllegalArgumentException("query must be parametrized");
        }
        long start = System.currentTimeMillis();
        PreparedStatement ps = null;
        try {
            ps = this.connection().prepareStatement(query);
            this.setParameters(ps, params);
            int count = ps.executeUpdate();
            LogFilter.logQuery(LOGGER, query, params, start);
            n = count;
        }
        catch (SQLException e) {
            try {
                this.logException("Failed query: " + query, e);
                throw new DBException(query, params, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(ps);
                throw throwable;
            }
        }
        Util.closeQuietly((AutoCloseable)ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object execInsert(String query, String autoIncrementColumnName, Object ... params) {
        if (!INSERT_PATTERN.matcher(query).find()) {
            throw new IllegalArgumentException("this method is only for inserts");
        }
        long start = System.currentTimeMillis();
        try {
            Object object;
            Connection connection = this.connection();
            PreparedStatement ps = StatementCache.instance().getPreparedStatement(connection, query);
            if (ps == null) {
                ps = connection.prepareStatement(query, new String[]{autoIncrementColumnName});
                StatementCache.instance().cache(connection, query, ps);
            }
            int index232 = 0;
            while (index232 < params.length) {
                Object param;
                if ((param = params[index232++]) instanceof byte[]) {
                    byte[] bytes = (byte[])param;
                    try {
                        Blob blob = connection.createBlob();
                        if (blob == null) {
                            ps.setBytes(index232, bytes);
                            continue;
                        }
                        blob.setBytes(1L, bytes);
                        ps.setBlob(index232, blob);
                    }
                    catch (AbstractMethodError | SQLException e) {
                        ps.setObject(index232, param);
                    }
                    continue;
                }
                ps.setObject(index232, param);
            }
            if (ps.executeUpdate() != 1) {
                return null;
            }
            ResultSet rs = null;
            try {
                Object id;
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    id = rs.getObject(1);
                    LogFilter.logQuery(LOGGER, query, params, start);
                    object = id;
                    return object;
                }
                id = -1;
                return id;
            }
            catch (SQLException e) {
                LOGGER.error("Failed to find out the auto-incremented value, returning -1, query: {}", (Object)query, (Object)e);
                object = -1;
                return object;
            }
            finally {
                Util.closeQuietly((AutoCloseable)rs);
            }
        }
        catch (SQLException e2) {
            throw new DBException(query, params, e2);
        }
    }

    private void logException(String message, Exception e) {
        if (LOGGER.isErrorEnabled() && Convert.toBoolean((Object)System.getProperty("activejdbc.log_exception")).booleanValue()) {
            LOGGER.error(message, (Throwable)e);
        }
    }

    public void openTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.name);
            if (c == null) {
                throw new DBException("Cannot open transaction, connection '" + this.name + "' not available");
            }
            c.setAutoCommit(false);
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Transaction opened");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public void commitTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.name);
            if (c == null) {
                throw new DBException("Cannot commit transaction, connection '" + this.name + "' not available");
            }
            c.commit();
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Transaction committed");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public void rollbackTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.name);
            if (c == null) {
                throw new DBException("Cannot rollback transaction, connection '" + this.name + "' not available");
            }
            c.rollback();
            LogFilter.log(LOGGER, LogLevel.DEBUG, "Transaction rolled back");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public Connection connection() {
        Connection connection = ConnectionsAccess.getConnection(this.name);
        if (connection == null) {
            throw new DBException("there is no connection '" + this.name + "' on this thread, are you sure you opened it?");
        }
        return connection;
    }

    public boolean hasConnection() {
        return null != ConnectionsAccess.getConnection(this.name);
    }

    public Connection getConnection() {
        return this.connection();
    }

    public static List<String> getCurrrentConnectionNames() {
        return new ArrayList<String>(ConnectionsAccess.getConnectionMap().keySet());
    }

    public static void closeAllConnections() {
        List<String> names = DB.getCurrrentConnectionNames();
        for (String name : names) {
            new DB(name).close();
        }
    }

    public static Map<String, Connection> connections() {
        return ConnectionsAccess.getConnectionMap();
    }

    public PreparedStatement startBatch(String parametrizedStatement) {
        try {
            return this.connection().prepareStatement(parametrizedStatement);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public void addBatch(PreparedStatement ps, Object ... params) {
        try {
            this.setParameters(ps, params);
            ps.addBatch();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public int[] executeBatch(PreparedStatement ps) {
        try {
            int[] counters = ps.executeBatch();
            ps.clearParameters();
            return counters;
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public void closePreparedStatement(PreparedStatement ps) {
        Util.closeQuietly((AutoCloseable)ps);
    }

    private void setParameters(PreparedStatement ps, Object ... params) throws SQLException {
        int index = 0;
        while (index < params.length) {
            Object param = params[index++];
            ps.setObject(index, param);
        }
    }

    public <T> T withDb(String jndiName, Properties jndiProperties, Supplier<T> supplier) {
        if (this.hasConnection()) {
            return supplier.get();
        }
        try (DB db = this.open(jndiName, jndiProperties);){
            T t = supplier.get();
            return t;
        }
    }

    public <T> T withDb(DataSource dataSource, Supplier<T> supplier) {
        if (this.hasConnection()) {
            return supplier.get();
        }
        try (DB db = this.open(dataSource);){
            T t = supplier.get();
            return t;
        }
    }

    public <T> T withDb(String jndiName, Supplier<T> supplier) {
        if (this.hasConnection()) {
            return supplier.get();
        }
        try (DB db = this.open(jndiName);){
            T t = supplier.get();
            return t;
        }
    }

    public <T> T withDb(String driver, String url, Properties properties, Supplier<T> supplier) {
        if (this.hasConnection()) {
            return supplier.get();
        }
        try (DB db = this.open(driver, url, properties);){
            T t = supplier.get();
            return t;
        }
    }

    public <T> T withDb(String driver, String url, String user, String password, Supplier<T> supplier) {
        if (this.hasConnection()) {
            return supplier.get();
        }
        try (DB db = this.open(driver, url, user, password);){
            T t = supplier.get();
            return t;
        }
    }

    public <T> T withDb(Supplier<T> supplier) {
        if (this.hasConnection()) {
            return supplier.get();
        }
        try (DB db = this.open();){
            T t = supplier.get();
            return t;
        }
    }
}

