/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.validation;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Locale;
import org.javalite.validation.Validatable;
import org.javalite.validation.ValidatorAdapter;

public class RangeValidator
extends ValidatorAdapter {
    private final String attribute;
    private final Number min;
    private final Number max;

    public RangeValidator(String attribute, Number min, Number max) {
        this.attribute = attribute;
        this.min = min;
        this.max = max;
        if (!min.getClass().equals(max.getClass())) {
            throw new IllegalArgumentException("min and max must be the same type");
        }
        this.setMessage("value should be within limits: > {0} and < {1}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(Validatable validatable) {
        if (validatable.get(this.attribute) == null) {
            validatable.addFailedValidator(this, this.attribute);
            return;
        }
        Object value = validatable.get(this.attribute);
        if (!value.getClass().equals(this.max.getClass())) {
            throw new IllegalArgumentException("attribute " + this.attribute + " type(class) must be the same type as range limits. Min type: " + this.min.getClass() + ", Max type: " + this.max.getClass() + ", Attribute name: " + this.attribute + ", attribute type: " + value.getClass());
        }
        if (value.getClass().equals(BigDecimal.class) || value.getClass().equals(BigDecimal.class)) {
            try {
                Method compareTo = value.getClass().getMethod("compareTo", new Class[0]);
                if ((Integer)compareTo.invoke(value, this.min) != -1 && (Integer)compareTo.invoke(value, this.max) != 1) return;
                validatable.addFailedValidator(this, this.attribute);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (value.getClass().equals(Byte.class)) {
            Byte v = (Byte)value;
            Byte mn = (Byte)this.min;
            Byte mx = (Byte)this.max;
            if (v <= mx && v >= mn) return;
            validatable.addFailedValidator(this, this.attribute);
            return;
        } else if (value.getClass().equals(Double.class)) {
            Double v = (Double)value;
            Double mn = (Double)this.min;
            Double mx = (Double)this.max;
            if (!(v > mx) && !(v < mn)) return;
            validatable.addFailedValidator(this, this.attribute);
            return;
        } else if (value.getClass().equals(Float.class)) {
            Float v = (Float)value;
            Float mn = (Float)this.min;
            Float mx = (Float)this.max;
            if (!(v.floatValue() > mx.floatValue()) && !(v.floatValue() < mn.floatValue())) return;
            validatable.addFailedValidator(this, this.attribute);
            return;
        } else if (value.getClass().equals(Integer.class)) {
            Integer v = (Integer)value;
            Integer mn = (Integer)this.min;
            Integer mx = (Integer)this.max;
            if (v <= mx && v >= mn) return;
            validatable.addFailedValidator(this, this.attribute);
            return;
        } else if (value.getClass().equals(Long.class)) {
            Long v = (Long)value;
            Long mn = (Long)this.min;
            Long mx = (Long)this.max;
            if (v <= mx && v >= mn) return;
            validatable.addFailedValidator(this, this.attribute);
            return;
        } else {
            if (!value.getClass().equals(Short.class)) return;
            Short v = (Short)value;
            Short mn = (Short)this.min;
            Short mx = (Short)this.max;
            if (v <= mx && v >= mn) return;
            validatable.addFailedValidator(this, this.attribute);
        }
    }

    @Override
    public String formatMessage(Locale locale, Object ... params) {
        return super.formatMessage(locale, this.min, this.max);
    }
}

