/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.validation.Validatable;
import org.javalite.validation.ValidatorAdapter;

public class RegexpValidator
extends ValidatorAdapter {
    private final Pattern pattern;
    private final String attribute;

    public RegexpValidator(String attribute, String rule) {
        this.pattern = Pattern.compile(rule, 2);
        this.attribute = attribute;
        this.setMessage("value does not match given format");
    }

    @Override
    public void validate(Validatable validatable) {
        if (validatable.get(this.attribute) == null) {
            validatable.addFailedValidator(this, this.attribute);
            return;
        }
        Object value = validatable.get(this.attribute);
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("attribute " + this.attribute + " is not String");
        }
        Matcher matcher = this.pattern.matcher((String)value);
        if (!matcher.matches()) {
            validatable.addFailedValidator(this, this.attribute);
        }
    }
}

