/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.validation;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.javalite.common.Util;
import org.javalite.validation.Validatable;
import org.javalite.validation.ValidatorAdapter;

public class TimestampValidator
extends ValidatorAdapter {
    private String attributeName;
    private String format;
    private SimpleDateFormat df;
    private final ThreadLocal<DateFormat> threadLocalFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)TimestampValidator.this.df.clone();
        }
    };

    public TimestampValidator(String attributeName, String format) {
        this.attributeName = attributeName;
        this.setMessage("attribute {0} does not conform to format: {1}");
        this.df = new SimpleDateFormat(format);
        this.format = format;
    }

    @Override
    public void validate(Validatable validatable) {
        Object val = validatable.get(this.attributeName);
        if (!(val instanceof Timestamp) && !Util.blank(val)) {
            try {
                this.threadLocalFormat.get().parse(val.toString()).getTime();
            }
            catch (ParseException e) {
                validatable.addFailedValidator(this, this.attributeName);
            }
        }
    }

    @Override
    public String formatMessage(Locale locale, Object ... params) {
        return super.formatMessage(locale, this.attributeName, this.format);
    }
}

