/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.mojo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.InjectableEmbedder;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderClassLoader;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.NullEmbedderMonitor;
import org.jbehave.core.embedder.UnmodifiableEmbedderControls;
import org.jbehave.core.embedder.executors.ExecutorServiceFactory;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;

public abstract class AbstractEmbedderMojo
extends AbstractMojo {
    static final String TEST_SCOPE = "test";
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    String sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", required=true)
    String testSourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    String outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    String testOutputDirectory;
    @Parameter(defaultValue="compile")
    String scope;
    @Parameter
    List<String> includes;
    @Parameter
    List<String> excludes;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    List<String> compileClasspathElements;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    List<String> testClasspathElements;
    @Parameter(defaultValue="false")
    boolean skip = false;
    @Parameter(defaultValue="false")
    boolean batch = false;
    @Parameter(defaultValue="false")
    boolean ignoreFailureInStories = false;
    @Parameter(defaultValue="false")
    boolean ignoreFailureInView = false;
    @Parameter(defaultValue="true")
    boolean generateViewAfterStories = true;
    @Parameter(defaultValue="false")
    boolean verboseFailures = false;
    @Parameter(defaultValue="false")
    boolean verboseFiltering = false;
    @Parameter
    String storyTimeouts;
    @Parameter(defaultValue="false")
    boolean failOnStoryTimeout = false;
    @Parameter(defaultValue="1")
    int threads = 1;
    @Parameter(defaultValue="org.jbehave.core.embedder.Embedder")
    String embedderClass = Embedder.class.getName();
    @Parameter
    String executorsClass;
    @Parameter
    String injectableEmbedderClass;
    @Parameter
    String storyFinderClass = StoryFinder.class.getName();
    @Parameter
    String[] metaFilters;
    @Parameter
    Properties systemProperties = new Properties();
    private EmbedderClassLoader classLoader;

    boolean isTestScope() {
        return TEST_SCOPE.equals(this.scope);
    }

    String searchDirectory() {
        if (this.isTestScope()) {
            return this.testSourceDirectory;
        }
        return this.sourceDirectory;
    }

    String outputDirectory() {
        if (this.isTestScope()) {
            return this.testOutputDirectory;
        }
        return this.outputDirectory;
    }

    URL codeLocation() {
        String outputDirectory = this.outputDirectory();
        try {
            return outputDirectory != null ? new File(outputDirectory).toURI().toURL() : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to create code location from " + outputDirectory, e);
        }
    }

    protected EmbedderClassLoader classLoader() {
        if (this.classLoader == null) {
            this.classLoader = new EmbedderClassLoader(this.classpathElements());
        }
        return this.classLoader;
    }

    List<String> classpathElements() {
        List<String> classpathElements = this.compileClasspathElements;
        if (this.isTestScope()) {
            classpathElements = this.testClasspathElements;
        }
        return classpathElements;
    }

    protected List<String> storyPaths() {
        this.getLog().debug((CharSequence)("Searching for story paths including " + this.includes + " and excluding " + this.excludes));
        List storyPaths = this.newStoryFinder().findPaths(this.searchDirectory(), this.includes, this.excludes);
        this.getLog().info((CharSequence)("Found story paths: " + storyPaths));
        return storyPaths;
    }

    protected List<String> classNames() {
        this.getLog().debug((CharSequence)("Searching for class names including " + this.includes + " and excluding " + this.excludes));
        List classNames = this.newStoryFinder().findClassNames(this.searchDirectory(), this.includes, this.excludes);
        this.getLog().info((CharSequence)("Found class names: " + classNames));
        return classNames;
    }

    protected StoryFinder newStoryFinder() {
        return (StoryFinder)this.classLoader().newInstance(StoryFinder.class, this.storyFinderClass);
    }

    protected Embedder newEmbedder() {
        Embedder embedder = null;
        EmbedderClassLoader classLoader = this.classLoader();
        embedder = this.injectableEmbedderClass != null ? ((InjectableEmbedder)classLoader.newInstance(InjectableEmbedder.class, this.injectableEmbedderClass)).injectedEmbedder() : (Embedder)classLoader.newInstance(Embedder.class, this.embedderClass);
        URL codeLocation = this.codeLocation();
        if (codeLocation != null) {
            embedder.configuration().storyReporterBuilder().withCodeLocation(codeLocation);
        }
        embedder.useClassLoader(classLoader);
        embedder.useEmbedderControls(this.embedderControls());
        if (this.executorsClass != null) {
            ExecutorServiceFactory executorServiceFactory = (ExecutorServiceFactory)classLoader.newInstance(ExecutorServiceFactory.class, this.executorsClass);
            embedder.useExecutorService(executorServiceFactory.create(embedder.embedderControls()));
        }
        embedder.useEmbedderMonitor(this.embedderMonitor());
        if (ArrayUtils.isNotEmpty((Object[])this.metaFilters)) {
            ArrayList<String> filters = new ArrayList<String>();
            for (String filter : this.metaFilters) {
                if (filter == null) continue;
                filters.add(filter);
            }
            embedder.useMetaFilters(filters);
        }
        if (!this.systemProperties.isEmpty()) {
            embedder.useSystemProperties(this.systemProperties);
        }
        return embedder;
    }

    protected EmbedderMonitor embedderMonitor() {
        return new MavenEmbedderMonitor();
    }

    protected EmbedderControls embedderControls() {
        EmbedderControls embedderControls = new EmbedderControls().doBatch(this.batch).doSkip(this.skip).doGenerateViewAfterStories(this.generateViewAfterStories).doIgnoreFailureInStories(this.ignoreFailureInStories).doIgnoreFailureInView(this.ignoreFailureInView).doVerboseFailures(this.verboseFailures).doVerboseFiltering(this.verboseFiltering).doFailOnStoryTimeout(this.failOnStoryTimeout).useThreads(this.threads);
        if (this.storyTimeouts != null) {
            embedderControls.useStoryTimeouts(this.storyTimeouts);
        }
        return new UnmodifiableEmbedderControls(embedderControls);
    }

    protected class MavenEmbedderMonitor
    extends NullEmbedderMonitor {
        protected MavenEmbedderMonitor() {
        }

        public void batchFailed(BatchFailures failures) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to run batch " + failures));
        }

        public void beforeOrAfterStoriesFailed() {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)"Failed to run before or after stories steps");
        }

        public void embeddableFailed(String name, Throwable cause) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to run embeddable " + name), cause);
        }

        public void embeddableNotConfigurable(String name) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Embeddable " + name + " must be an instance of " + ConfigurableEmbedder.class));
        }

        public void embeddablesSkipped(List<String> classNames) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Skipped embeddables " + classNames));
        }

        public void metaExcluded(Meta meta, MetaFilter filter) {
            AbstractEmbedderMojo.this.getLog().debug((CharSequence)(meta + " excluded by filter '" + filter.asString() + "'"));
        }

        public void runningEmbeddable(String name) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Running embeddable " + name));
        }

        public void runningStory(String path) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Running story " + path));
        }

        public void storyFailed(String path, Throwable cause) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to run story " + path), cause);
        }

        public void storiesSkipped(List<String> storyPaths) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Skipped stories " + storyPaths));
        }

        public void storiesExcluded(List<Story> excluded, MetaFilter filter, boolean verbose) {
            StringBuilder sb = new StringBuilder();
            sb.append(excluded.size() + " stories excluded by filter: " + filter.asString() + "\n");
            if (verbose) {
                for (Story story : excluded) {
                    sb.append(story.getPath()).append("\n");
                }
            }
            AbstractEmbedderMojo.this.getLog().info((CharSequence)sb.toString());
        }

        public void scenarioExcluded(Scenario scenario, MetaFilter filter) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Scenario '" + scenario.getTitle() + "' excluded by filter: " + filter.asString() + "\n"));
        }

        public void runningWithAnnotatedEmbedderRunner(String className) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Running with AnnotatedEmbedderRunner '" + className + "'"));
        }

        public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Annotated instance " + annotatedInstance + " not of type " + type));
        }

        public void generatingReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Generating reports view to '" + outputDirectory + "' using formats '" + formats + "' and view properties '" + viewProperties + "'"));
        }

        public void reportsViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
            String message = "Failed to generate reports view to '" + outputDirectory + "' using formats '" + formats + "' and view properties '" + viewProperties + "'";
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)message, cause);
        }

        public void reportsViewGenerated(ReportsCount count) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Reports view generated with " + count.getStories() + " stories (of which " + count.getStoriesPending() + " pending) containing " + count.getScenarios() + " scenarios (of which " + count.getScenariosPending() + " pending)"));
            if (count.getStoriesExcluded() > 0 || count.getScenariosExcluded() > 0) {
                AbstractEmbedderMojo.this.getLog().info((CharSequence)("Meta filters excluded " + count.getStoriesExcluded() + " stories and  " + count.getScenariosExcluded() + " scenarios"));
            }
        }

        public void reportsViewFailures(ReportsCount count) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failures in reports view: " + count.getScenariosFailed() + " scenarios failed"));
        }

        public void reportsViewNotGenerated() {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)"Reports view not generated");
        }

        public void mappingStory(String storyPath, List<String> metaFilters) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Mapping story " + storyPath + " with meta filters " + metaFilters));
        }

        public void generatingMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Generating maps view to '" + outputDirectory + "' using story maps '" + storyMaps + "' and view properties '" + viewProperties + "'"));
        }

        public void mapsViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewProperties, Throwable cause) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to generate maps view to '" + outputDirectory + "' using story maps '" + storyMaps + "' and view properties '" + viewProperties + "'"), cause);
        }

        public void processingSystemProperties(Properties properties) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Processing system properties " + properties));
        }

        public void systemPropertySet(String name, String value) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("System property '" + name + "' set to '" + value + "'"));
        }

        public void storyTimeout(Story story, StoryDuration storyDuration) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Story " + story.getPath() + " duration of " + storyDuration.getDurationInSecs() + " seconds has exceeded timeout of " + storyDuration.getTimeoutInSecs() + " seconds"));
        }

        public void usingThreads(int threads) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Using " + threads + " threads"));
        }

        public void usingExecutorService(ExecutorService executorService) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Using executor service " + executorService));
        }

        public void usingControls(EmbedderControls embedderControls) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Using controls " + embedderControls));
        }

        public void invalidTimeoutFormat(String path) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to set specific story timeout for story " + path + " because 'storyTimeoutInSecsByPath' has incorrect format"));
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)"'storyTimeoutInSecsByPath' must be a CSV of regex expressions matching story paths. E.g. \"*/long/*.story:5000,*/short/*.story:200\"");
        }

        public void usingTimeout(String path, long timeout) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Using timeout for story " + path + " of " + timeout + " secs."));
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
    }
}

