/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.AbstractCsvReader;
import org.supercsv.io.ICsvMapReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.Util;

final class FastForwardCsvMapReader
extends AbstractCsvReader
implements ICsvMapReader {
    private final int startRowNumber;

    public FastForwardCsvMapReader(Reader reader, CsvPreference preferences, int startRowNumber) {
        super(reader, preferences);
        this.startRowNumber = startRowNumber;
    }

    public Map<String, String> read(String ... nameMapping) throws IOException {
        this.fastForwardToStartRow();
        if (nameMapping == null) {
            throw new NullPointerException("nameMapping should not be null");
        }
        if (this.readRow()) {
            HashMap<String, String> destination = new HashMap<String, String>();
            Util.filterListToMap(destination, (String[])nameMapping, (List)this.getColumns());
            return destination;
        }
        return null;
    }

    public Map<String, Object> read(String[] nameMapping, CellProcessor[] processors) throws IOException {
        this.fastForwardToStartRow();
        if (nameMapping == null) {
            throw new NullPointerException("nameMapping should not be null");
        }
        if (processors == null) {
            throw new NullPointerException("processors should not be null");
        }
        if (this.readRow()) {
            List processedColumns = this.executeProcessors(new ArrayList(this.getColumns().size()), processors);
            HashMap<String, Object> destination = new HashMap<String, Object>(processedColumns.size());
            Util.filterListToMap(destination, (String[])nameMapping, (List)processedColumns);
            return destination;
        }
        return null;
    }

    private void fastForwardToStartRow() throws IOException {
        while (this.getRowNumber() < this.startRowNumber) {
            this.readRow();
        }
    }
}

