/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.InputDecorator;
import java.io.Serializable;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.JsonItemReaderWriterBase;
import org.jberet.support.io.MappingJsonFactoryObjectFactory;

@Named
@Dependent
public class JsonItemReader
extends JsonItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonParserFeatures;
    @Inject
    @BatchProperty
    protected String deserializationFeatures;
    @Inject
    @BatchProperty
    protected String deserializationProblemHandlers;
    @Inject
    @BatchProperty
    protected Class inputDecorator;
    @Inject
    @BatchProperty
    protected String customDeserializers;
    private JsonParser jsonParser;
    private JsonToken token;
    private int rowNumber;

    public void open(Serializable checkpoint) throws Exception {
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (checkpoint != null) {
            this.start = (Integer)checkpoint;
        }
        if (this.start > this.end) {
            throw SupportLogger.LOGGER.invalidStartPosition((Integer)checkpoint, this.start, this.end);
        }
        super.initJsonFactoryAndObjectMapper();
        if (this.inputDecorator != null) {
            this.jsonFactory.setInputDecorator((InputDecorator)this.inputDecorator.newInstance());
        }
        if (this.deserializationFeatures != null) {
            MappingJsonFactoryObjectFactory.configureDeserializationFeatures(this.objectMapper, this.deserializationFeatures);
        }
        this.registerModule();
        this.jsonParser = this.jsonFactory.createParser(this.getInputStream(false));
        if (this.deserializationProblemHandlers != null) {
            MappingJsonFactoryObjectFactory.configureDeserializationProblemHandlers(this.objectMapper, this.deserializationProblemHandlers, this.getClass().getClassLoader());
        }
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        if (this.jsonParserFeatures != null) {
            for (Map.Entry<String, String> e : this.jsonParserFeatures.entrySet()) {
                JsonParser.Feature feature;
                String key = e.getKey();
                String value = e.getValue();
                try {
                    feature = JsonParser.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.jsonParser.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.jsonParser.configure(feature, false);
                    continue;
                }
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, value, key);
            }
        }
    }

    public Object readItem() throws Exception {
        if (this.rowNumber >= this.end) {
            return null;
        }
        int nestedObjectLevel = 0;
        while (true) {
            this.token = this.jsonParser.nextToken();
            if (this.token == null) {
                return null;
            }
            if (this.token == JsonToken.START_OBJECT) {
                if (++nestedObjectLevel == 1) {
                    ++this.rowNumber;
                } else if (nestedObjectLevel < 1) {
                    throw SupportLogger.LOGGER.unexpectedJsonContent(this.jsonParser.getCurrentLocation());
                }
                if (this.rowNumber < this.start) continue;
                break;
            }
            if (this.token != JsonToken.END_OBJECT) continue;
            --nestedObjectLevel;
        }
        return this.objectMapper.readValue(this.jsonParser, this.beanType);
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.rowNumber);
    }

    public void close() throws Exception {
        if (this.jsonParser != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            if (this.deserializationProblemHandlers != null) {
                this.objectMapper.clearProblemHandlers();
            }
            this.jsonParser.close();
            this.jsonParser = null;
        }
    }

    @Override
    protected void registerModule() throws Exception {
        MappingJsonFactoryObjectFactory.configureCustomSerializersAndDeserializers(this.objectMapper, null, this.customDeserializers, this.getClass().getClassLoader());
    }
}

