/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded.shrinkwrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.container.weld.embedded.shrinkwrap.ShrinkwrapBeanDeploymentArchive;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class ShrinkwrapBeanDeploymentArchiveImpl
extends AssignableBase<Archive<?>>
implements ShrinkwrapBeanDeploymentArchive {
    private ServiceRegistry serviceRegistry = new SimpleServiceRegistry();
    private ShrinkWrapClassLoader classLoader;
    private Bootstrap bootstrap;

    public ShrinkwrapBeanDeploymentArchiveImpl(Archive<?> archive) {
        super(archive);
        Validate.notNull(archive, (String)"Archive must be specified");
        this.classLoader = new ShrinkWrapClassLoader(archive.getClass().getClassLoader(), new Archive[]{archive});
        this.serviceRegistry.add(ResourceLoader.class, (Service)new ResourceLoader(){

            public void cleanup() {
            }

            public Collection<URL> getResources(String name) {
                try {
                    return Collections.list(ShrinkwrapBeanDeploymentArchiveImpl.this.classLoader.getResources(name));
                }
                catch (Exception e) {
                    throw new ResourceLoadingException((Throwable)e);
                }
            }

            public URL getResource(String name) {
                return ShrinkwrapBeanDeploymentArchiveImpl.this.classLoader.getResource(name);
            }

            public Class<?> classForName(String name) {
                try {
                    return ShrinkwrapBeanDeploymentArchiveImpl.this.classLoader.loadClass(name);
                }
                catch (Exception e) {
                    throw new ResourceLoadingException((Throwable)e);
                }
            }
        });
    }

    @Override
    public ShrinkWrapClassLoader getClassLoader() {
        return this.classLoader;
    }

    public BeansXml getBeansXml() {
        if (this.bootstrap == null) {
            throw new RuntimeException("setBootstrap must be set. Needed to parse Beans XML");
        }
        ArrayList<URL> beansXmls = new ArrayList<URL>();
        Map classes = this.getArchive().getContent(Filters.include((String)".*/beans.xml"));
        for (final Map.Entry entry : classes.entrySet()) {
            try {
                beansXmls.add(new URL(null, "archive://" + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return ((Node)entry.getValue()).getAsset().openStream();
                            }
                        };
                    }
                }));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.bootstrap.parse(beansXmls);
    }

    public Collection<String> getBeanClasses() {
        Map markerFiles = this.getArchive().getContent(Filters.include((String)".*/beans.xml"));
        if (markerFiles.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<String> beanClasses = new ArrayList<String>();
        Map classes = this.getArchive().getContent(Filters.include((String)".*\\.class"));
        for (Map.Entry classEntry : classes.entrySet()) {
            beanClasses.add(this.getClassName((ArchivePath)classEntry.getKey()));
        }
        return beanClasses;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.emptySet();
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.emptySet();
    }

    public String getId() {
        return this.getArchive().getName();
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public String getClassName(ArchivePath path) {
        String className = path.get();
        if (className.charAt(0) == '/') {
            className = className.substring(1);
        }
        className = className.replaceAll("\\.class", "");
        className = className.replaceAll("/", ".");
        return className;
    }
}

