/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.arquillian.container.weld.embedded.mock.Ejbs;
import org.jboss.arquillian.container.weld.embedded.mock.MockEjbInjectionServices;
import org.jboss.arquillian.container.weld.embedded.mock.MockJpaInjectionServices;
import org.jboss.arquillian.container.weld.embedded.mock.MockResourceInjectionServices;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;

public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private final Collection<String> beanClasses;
    private final BeansXml beansXml;
    private final Collection<EjbDescriptor<?>> ejbs;
    private final ServiceRegistry services = new SimpleServiceRegistry();
    private final Collection<BeanDeploymentArchive> bdas = new HashSet<BeanDeploymentArchive>();
    private final String id;

    public BeanDeploymentArchiveImpl(BeansXml beansXml, Iterable<Class<?>> classes, Environment environment) {
        this("test", beansXml, classes, environment);
    }

    public BeanDeploymentArchiveImpl(Iterable<Class<?>> classes) {
        this("test", BeansXml.EMPTY_BEANS_XML, classes, (Environment)Environments.SE);
    }

    public BeanDeploymentArchiveImpl(Iterable<Class<?>> classes, Environment environment) {
        this("test", BeansXml.EMPTY_BEANS_XML, classes, environment);
    }

    public BeanDeploymentArchiveImpl(String id, Environment environment, Class<?> ... classes) {
        this(id, BeansXml.EMPTY_BEANS_XML, Arrays.asList(classes), environment);
    }

    public BeanDeploymentArchiveImpl(String id, Class<?> ... classes) {
        this(id, BeansXml.EMPTY_BEANS_XML, Arrays.asList(classes), (Environment)Environments.SE);
    }

    public BeanDeploymentArchiveImpl(String id, BeansXml beansXml, Environment environment, Class<?> ... classes) {
        this(id, beansXml, Arrays.asList(classes), environment);
    }

    public BeanDeploymentArchiveImpl(String id, BeansXml beansXml, Class<?> ... classes) {
        this(id, beansXml, Arrays.asList(classes), (Environment)Environments.SE);
    }

    public BeanDeploymentArchiveImpl(String id, BeansXml beansXml, Iterable<Class<?>> beanClasses, Environment environment) {
        this.beanClasses = new ArrayList<String>();
        for (Class<?> clazz : beanClasses) {
            this.beanClasses.add(clazz.getName());
        }
        this.beansXml = beansXml;
        this.ejbs = Ejbs.createEjbDescriptors(beanClasses);
        this.id = id;
        this.configureServices(environment);
    }

    protected void configureServices(Environment environment) {
        if (environment.equals(Environments.EE) || environment.equals(Environments.EE_INJECT)) {
            this.services.add(EjbInjectionServices.class, (Service)new MockEjbInjectionServices());
            this.services.add(JpaInjectionServices.class, (Service)new MockJpaInjectionServices());
        }
        this.services.add(ResourceInjectionServices.class, (Service)new MockResourceInjectionServices());
    }

    public Collection<String> getBeanClasses() {
        return this.beanClasses;
    }

    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.bdas;
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbs;
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BeanDeploymentArchiveImpl) {
            BeanDeploymentArchiveImpl that = (BeanDeploymentArchiveImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

