/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static Map<String, Field> getAccessableFields(final Class<?> source) {
        Map<String, Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<Map<String, Field>>(){

            @Override
            public Map<String, Field> run() {
                LinkedHashMap<String, Field> foundFields = new LinkedHashMap<String, Field>();
                for (Field field : source.getDeclaredFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    foundFields.put(field.getName(), field);
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    static Map<String, String> getProperties(final String prefix) {
        try {
            Map<String, String> value = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, String>>(){

                @Override
                public Map<String, String> run() {
                    Properties props = System.getProperties();
                    LinkedHashMap<String, String> subset = new LinkedHashMap<String, String>();
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String name = entry.getKey().toString();
                        if (!name.startsWith(prefix)) continue;
                        subset.put(name, entry.getValue().toString());
                    }
                    return subset;
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static List<Field> getMapFields(final Class<?> source, final Class<?> ... parameters) {
        try {
            List<Field> value = AccessController.doPrivileged(new PrivilegedExceptionAction<List<Field>>(){

                @Override
                public List<Field> run() {
                    Map<String, Field> accesableFields = SecurityActions.getAccessableFields(source);
                    ArrayList<Field> fields = new ArrayList<Field>();
                    for (Field field : accesableFields.values()) {
                        if (!Map.class.isAssignableFrom(field.getType())) continue;
                        Type genericType = field.getGenericType();
                        boolean parameterMatched = true;
                        if (genericType instanceof ParameterizedType) {
                            ParameterizedType parameterizedType = (ParameterizedType)genericType;
                            if (parameterizedType.getActualTypeArguments().length != parameters.length) {
                                parameterMatched = false;
                            } else {
                                for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                                    Class actualType = (Class)parameterizedType.getActualTypeArguments()[i];
                                    if (actualType.equals(parameters[i])) continue;
                                    parameterMatched = false;
                                    break;
                                }
                            }
                        }
                        if (!parameterMatched) continue;
                        fields.add(field);
                    }
                    return fields;
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }
}

