/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointFilter;
import org.jboss.arquillian.drone.spi.FilterableResult;

public class FilterableResultImpl<DRONE>
implements FilterableResult<DRONE> {
    private final DroneContext context;
    private final Set<DronePoint<DRONE>> wrapped;

    public FilterableResultImpl(DroneContext context, Set<DronePoint<DRONE>> wrapped) {
        if (context == null) {
            throw new IllegalArgumentException("DroneContext cannot be null!");
        }
        if (wrapped == null) {
            throw new IllegalArgumentException("Wrapped Set cannot be null!");
        }
        this.context = context;
        this.wrapped = wrapped;
    }

    public FilterableResult<DRONE> filter(DronePointFilter<? super DRONE> filter) {
        HashSet<DronePoint<DRONE>> dronePoints = new HashSet<DronePoint<DRONE>>();
        for (DronePoint<DRONE> dronePoint : this.wrapped) {
            if (!filter.accepts(this.context, dronePoint)) continue;
            dronePoints.add(dronePoint);
        }
        return new FilterableResultImpl<DRONE>(this.context, dronePoints);
    }

    public DronePoint<DRONE> single() {
        int count = this.size();
        if (count != 1) {
            StringBuilder builder = new StringBuilder("Total injection points matched not equal to 1! Actual count: ");
            builder.append(count).append(". Matched points: [ ");
            int i = 0;
            for (DronePoint<DRONE> dronePoint : this.wrapped) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(dronePoint);
                ++i;
            }
            builder.append(" ]");
            throw new IllegalStateException(builder.toString());
        }
        return this.wrapped.iterator().next();
    }

    public int size() {
        return this.wrapped.size();
    }

    public Iterator<DronePoint<DRONE>> iterator() {
        return this.wrapped.iterator();
    }
}

