/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.configuration.mapping.ValueMapper;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class CapabilitiesOptionsMapper {
    public static void mapCapabilities(Object object, DesiredCapabilities capabilities, String browserPrefix) {
        Method[] methods = object.getClass().getMethods();
        ArrayList<String> processedMethods = new ArrayList<String>();
        for (Method method : methods) {
            if (!CapabilitiesOptionsMapper.isSetter(method)) continue;
            method.setAccessible(true);
            String methodName = method.getName();
            if (processedMethods.contains(methodName)) continue;
            String propertyName = browserPrefix + methodName.substring(3);
            String capability = (String)capabilities.getCapability(propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1));
            if (!Validate.nonEmpty(capability)) continue;
            try {
                if (method.getParameterTypes().length == 1) {
                    Object converted = CapabilitiesOptionsMapper.convert(method, capability);
                    if (converted == null) continue;
                    method.invoke(object, converted);
                    processedMethods.add(methodName);
                    continue;
                }
                if (!CapabilitiesOptionsMapper.shouldContainDictionaries(method)) continue;
                CapabilitiesOptionsMapper.handleDictionaries(object, method, capability);
                processedMethods.add(methodName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void handleDictionaries(Object object, Method method, String capability) throws InvocationTargetException, IllegalAccessException {
        String trimmedCapability = StringUtils.trimMultiline(capability);
        JsonObject json = new JsonParser().parse(trimmedCapability).getAsJsonObject();
        Set entries = json.entrySet();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Map values = (Map)new Gson().fromJson((JsonElement)entry.getValue(), type);
            method.invoke(object, key, values);
        }
    }

    private static boolean shouldContainDictionaries(Method method) {
        return !(method.getParameterTypes().length != 2 || !method.getParameterTypes()[0].isAssignableFrom(String.class) && !method.getParameterTypes()[0].isAssignableFrom(Object.class) || !method.getParameterTypes()[1].isAssignableFrom(Object.class) && !method.getParameterTypes()[1].isAssignableFrom(Map.class));
    }

    private static Object convert(Method method, String capability) {
        Class<List> parameterType = method.getParameterTypes()[0];
        Object converted = null;
        Object obj = CapabilitiesOptionsMapper.convertToBooleanNumberStringOrFile(parameterType, capability);
        converted = obj;
        if (obj != null) {
            return converted;
        }
        if (parameterType.isArray()) {
            return CapabilitiesOptionsMapper.handleArray(parameterType.getComponentType(), capability);
        }
        if (parameterType.isAssignableFrom(List.class)) {
            return CapabilitiesOptionsMapper.handleList(method, capability);
        }
        return null;
    }

    private static <T> T[] handleArray(Class<T> parameterType, String capability) {
        List<Object> convertedList = CapabilitiesOptionsMapper.getConvertedList(parameterType, capability);
        Object[] array = (Object[])Array.newInstance(parameterType, convertedList.size());
        return convertedList.toArray(array);
    }

    private static Object handleList(Method method, String capability) {
        Type[] parameters;
        Type type;
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (genericParameterTypes.length == 1 && (type = genericParameterTypes[0]) instanceof ParameterizedType && (parameters = ((ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return CapabilitiesOptionsMapper.getConvertedList((Class)parameters[0], capability);
        }
        return null;
    }

    private static <T> List<T> getConvertedList(Class<T> parameter, String capability) {
        List<String> values = StringUtils.tokenize(capability);
        ArrayList<T> convertedList = new ArrayList<T>(values.size());
        for (String value : values) {
            convertedList.add(CapabilitiesOptionsMapper.convertToBooleanNumberStringOrFile(parameter, value));
        }
        return convertedList;
    }

    private static <T> T convertToBooleanNumberStringOrFile(Class<T> clazz, String value) {
        for (ValueMapper mapper : ConfigurationMapper.VALUE_MAPPERS) {
            if (!mapper.handles(clazz, new Class[0])) continue;
            return (T)mapper.transform(value);
        }
        return null;
    }

    private static boolean isSetter(Method candidate) {
        return candidate.getName().matches("^(set|add)[A-Z].*") && candidate.getReturnType().equals(Void.TYPE) && candidate.getParameterTypes().length > 0;
    }
}

