/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.InitializationParameter;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSession;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStore;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStoreImpl;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.SerializationWhitelist;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SerializationUtils {
    private static final SerializationWhitelist whitelist = new SerializationWhitelist();

    public static byte[] serializeToBytes(Serializable object) throws IOException {
        if (!whitelist.isEnabled(object.getClass().getName())) {
            throw new InvalidClassException("Rejecting request to serialize " + object.getClass().getName() + ", class is not whitelisted for serialization.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        return baos.toByteArray();
    }

    public static <T extends Serializable> T deserializeFromBytes(Class<T> classType, byte[] serializedObject) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedObject);
        LookAheadObjectInputStream ois = new LookAheadObjectInputStream(bais, whitelist);
        return (T)((Serializable)classType.cast(ois.readObject()));
    }

    static {
        whitelist.enableClass(URL.class.getName());
        whitelist.enableClass(URI.class.getName());
        whitelist.enableClass(Date.class.getName());
        whitelist.enableClass(File.class.getName());
        whitelist.enableClass(LinkedHashMap.class.getName());
        whitelist.enableClass(HashMap.class.getName());
        whitelist.enableClass(Map.class.getName());
        whitelist.enableClass(List.class.getName());
        whitelist.enableClass(ArrayList.class.getName());
        whitelist.enableClass(LinkedList.class.getName());
        whitelist.enableClass(DesiredCapabilities.class.getName());
        whitelist.enableClass(Capabilities.class.getName());
        whitelist.enableClass(Platform.class.getName());
        whitelist.enableClass(ReusedSession.class.getName());
        whitelist.enableClass(ReusedSessionStore.class.getName());
        whitelist.enableClass(ReusedSessionStoreImpl.class.getName());
        whitelist.enableClass(ReusedSessionStoreImpl.ByteArray.class.getName());
        whitelist.enableClass(ReusedSessionStoreImpl.TimeStampedSession.class.getName());
        whitelist.enableClass(InitializationParameter.class.getName());
    }

    public static class LookAheadObjectInputStream
    extends ObjectInputStream {
        private final SerializationWhitelist whitelist;

        public LookAheadObjectInputStream(InputStream inputStream, SerializationWhitelist whitelist) throws IOException {
            super(inputStream);
            this.whitelist = whitelist;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (!this.whitelist.isEnabled(desc.getName())) {
                throw new InvalidClassException("Unauthorized deserialization attempt", desc.getName());
            }
            return super.resolveClass(desc);
        }
    }
}

