/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizableURLResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<GrapheneConfiguration> grapheneConfiguration;

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String grapheneCustomURL;
        URL url = this.doLookup(resource, qualifiers);
        if (url == null && (grapheneCustomURL = ((GrapheneConfiguration)this.grapheneConfiguration.get()).getUrl()) != null) {
            try {
                url = new URL(grapheneCustomURL);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Configured custom URL from GrapheneConfiguration should be already a valid URL.");
            }
        }
        return url;
    }

    protected URL doLookup(ArquillianResource resource, Annotation ... qualifiers) {
        return null;
    }
}

