/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.helpers.ManagedObjectsWithTransientAttachmentsImpl;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentContextVisitor;
import org.jboss.deployers.structure.spi.DeploymentMBean;
import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContextMBean;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.DefaultDeploymentContextComparator;
import org.jboss.deployers.structure.spi.helpers.DeploymentResourceClassLoader;
import org.jboss.deployers.structure.spi.helpers.EmptyResourceLoader;
import org.jboss.deployers.structure.spi.helpers.TrackingMutableAttachments;
import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
import org.jboss.deployers.structure.spi.scope.helpers.DefaultScopeBuilder;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDeploymentContext
extends ManagedObjectsWithTransientAttachmentsImpl
implements DeploymentContext,
AbstractDeploymentContextMBean,
MBeanRegistration {
    private static final long serialVersionUID = 7368360479461613969L;
    private static final Logger log = Logger.getLogger(AbstractDeploymentContext.class);
    private String name;
    private ObjectName objectName;
    private MBeanServer server;
    private Set<Object> controllerContextNames;
    private String simpleName;
    private String relativePath;
    private DeploymentState state;
    private Throwable problem;
    private Deployment deployment;
    private transient DeploymentUnit unit;
    private transient ClassLoader classLoader;
    private transient ClassLoaderFactory classLoaderFactory;
    private transient ClassLoader resourceClassLoader;
    private boolean deployed;
    private DeploymentContext parent;
    private Set<String> deploymentTypes = new CopyOnWriteArraySet<String>();
    private SortedSet<DeploymentContext> children;
    private List<DeploymentContext> components = new CopyOnWriteArrayList<DeploymentContext>();
    private int relativeOrder;
    private Comparator<DeploymentContext> comparator = DefaultDeploymentContextComparator.INSTANCE;
    private ScopeKey scope;
    private ScopeKey mutableScope;
    private transient TrackingMutableAttachments transientManagedObjects;
    private transient TrackingMutableAttachments transientAttachments;
    private DeploymentStage requiredStage = DeploymentStages.INSTALLED;

    public static ScopeBuilder getScopeBuilder(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
        if (builder != null) {
            return builder;
        }
        DeploymentContext parent = deploymentContext.getParent();
        if (parent != null) {
            return AbstractDeploymentContext.getScopeBuilder(parent);
        }
        return DefaultScopeBuilder.INSTANCE;
    }

    public static MutableMetaDataRepository getRepository(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        MutableMetaDataRepository repository = (MutableMetaDataRepository)deploymentContext.getTransientAttachments().getAttachment(MutableMetaDataRepository.class);
        if (repository != null) {
            return repository;
        }
        DeploymentContext parent = deploymentContext.getParent();
        if (parent == null) {
            return null;
        }
        return AbstractDeploymentContext.getRepository(parent);
    }

    public static void cleanupRepository(DeploymentContext deploymentContext) {
        ScopeKey scope;
        MutableMetaDataRepository repository = AbstractDeploymentContext.getRepository(deploymentContext);
        if (repository == null) {
            return;
        }
        try {
            scope = deploymentContext.getScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            scope = deploymentContext.getMutableScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MetaData getMetaData(DeploymentContext deploymentContext) {
        MutableMetaDataRepository repository = AbstractDeploymentContext.getRepository(deploymentContext);
        if (repository == null) {
            return null;
        }
        MetaData metaData = repository.getMetaData(deploymentContext.getScope());
        if (metaData == null) {
            AbstractDeploymentContext.initMetaDataRetrieval(repository, deploymentContext);
            metaData = repository.getMetaData(deploymentContext.getScope());
        }
        return metaData;
    }

    public static MutableMetaDataLoader getMutableMetaData(DeploymentContext deploymentContext) {
        MetaDataContext context;
        List locals;
        MutableMetaDataRepository repository = AbstractDeploymentContext.getRepository(deploymentContext);
        if (repository == null) {
            return null;
        }
        ScopeKey mutableScope = deploymentContext.getMutableScope();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(mutableScope);
        if (retrieval == null) {
            AbstractDeploymentContext.initMutableMetaDataRetrieval(repository, deploymentContext);
            retrieval = repository.getMetaDataRetrieval(mutableScope);
        }
        if (retrieval == null) {
            return null;
        }
        if (retrieval instanceof MutableMetaDataLoader) {
            return (MutableMetaDataLoader)retrieval;
        }
        if (retrieval instanceof MetaDataContext && (locals = (context = (MetaDataContext)retrieval).getLocalRetrievals()) != null) {
            for (MetaDataRetrieval local : locals) {
                if (!(local instanceof MutableMetaDataLoader)) continue;
                return (MutableMetaDataLoader)local;
            }
        }
        return null;
    }

    private static void initMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
        if (builder == null) {
            builder = DefaultScopeBuilder.INSTANCE;
        }
        builder.initMetaDataRetrieval(repository, deploymentContext);
    }

    private static void initMutableMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
        if (builder == null) {
            builder = DefaultScopeBuilder.INSTANCE;
        }
        builder.initMutableMetaDataRetrieval(repository, deploymentContext);
    }

    public AbstractDeploymentContext() {
        this.transientManagedObjects = new TrackingMutableAttachments(super.getTransientManagedObjects());
        this.transientAttachments = new TrackingMutableAttachments(super.getTransientAttachments());
    }

    public AbstractDeploymentContext(String name, String relativePath) {
        this(name, name, relativePath);
    }

    public AbstractDeploymentContext(String name, String simpleName, String relativePath) {
        this();
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Null relative path");
        }
        this.name = name;
        this.simpleName = simpleName;
        if (simpleName == null) {
            this.simpleName = name;
        }
        this.relativePath = relativePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            String type = "Deployment";
            if (this.getParent() != null) {
                type = "SubDeployment";
            }
            if (this.isComponent()) {
                type = "Component";
            }
            String name = this.getName();
            name = name.replace("\"", "&quot;");
            String temp = "jboss.deployment:id=\"" + name + "\",type=" + type;
            try {
                this.objectName = new ObjectName(temp);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException("Error creating object name: " + temp, e);
            }
        }
        return this.objectName;
    }

    @Override
    public Set<Object> getControllerContextNames() {
        return this.controllerContextNames != null ? Collections.unmodifiableSet(this.controllerContextNames) : null;
    }

    @Override
    public synchronized void addControllerContextName(Object name) {
        if (this.controllerContextNames == null) {
            this.controllerContextNames = new HashSet<Object>();
        }
        this.controllerContextNames.add(name);
    }

    @Override
    public synchronized void removeControllerContextName(Object name) {
        if (this.controllerContextNames != null) {
            this.controllerContextNames.remove(name);
            if (this.controllerContextNames.isEmpty()) {
                this.controllerContextNames = null;
            }
        } else {
            log.warn((Object)("Removing name on null names: " + name));
        }
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    @Override
    public void setRelativeOrder(int relativeOrder) {
        this.relativeOrder = relativeOrder;
    }

    @Override
    public Comparator<DeploymentContext> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<DeploymentContext> comparator) {
        if (comparator == null) {
            comparator = DefaultDeploymentContextComparator.INSTANCE;
        }
        this.comparator = comparator;
    }

    @Override
    public ScopeKey getScope() {
        if (this.scope == null) {
            ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
            this.scope = builder.getDeploymentScope(this);
        }
        return this.scope;
    }

    @Override
    public void setScope(ScopeKey scope) {
        this.scope = scope;
    }

    @Override
    public ScopeKey getMutableScope() {
        if (this.mutableScope == null) {
            ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
            this.mutableScope = builder.getMutableDeploymentScope(this);
        }
        return this.mutableScope;
    }

    @Override
    public void setMutableScope(ScopeKey mutableScope) {
        this.mutableScope = mutableScope;
    }

    @Override
    public MetaData getMetaData() {
        return AbstractDeploymentContext.getMetaData(this);
    }

    @Override
    public MutableMetaData getMutableMetaData() {
        return AbstractDeploymentContext.getMutableMetaData(this);
    }

    @Override
    public DeploymentState getState() {
        return this.state;
    }

    @Override
    public void setState(DeploymentState state) {
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        this.state = state;
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public void setDeployment(Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        this.deployment = deployment;
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        if (this.unit == null) {
            this.unit = this.createDeploymentUnit();
        }
        return this.unit;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit unit) {
        this.unit = unit;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ObjectName getClassLoaderName() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null || !(classLoader instanceof RealClassLoader)) {
            return null;
        }
        return ((RealClassLoader)classLoader).getObjectName();
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (classLoader != null && log.isTraceEnabled()) {
            log.trace((Object)("ClassLoader for " + this.name + " is " + classLoader));
        }
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            return false;
        }
        try {
            cl = factory.createClassLoader(this.getDeploymentUnit());
            if (cl != null) {
                this.setClassLoader(cl);
                this.classLoaderFactory = factory;
            } else {
                this.setClassLoader(Thread.currentThread().getContextClassLoader());
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error creating classloader for " + this.getName()), (Throwable)t);
        }
        return true;
    }

    @Override
    public void removeClassLoader() {
        if (this.classLoaderFactory == null) {
            return;
        }
        try {
            this.classLoaderFactory.removeClassLoader(this.getDeploymentUnit());
        }
        catch (Throwable t) {
            log.warn((Object)("Error removing classloader for " + this.getName()), t);
        }
        this.classLoaderFactory = null;
        this.setClassLoader(null);
    }

    @Override
    public void removeClassLoader(ClassLoaderFactory factory) {
        if (this.classLoaderFactory == factory) {
            this.removeClassLoader();
        }
    }

    @Override
    public boolean isTopLevel() {
        return this.parent == null;
    }

    @Override
    public DeploymentContext getTopLevel() {
        DeploymentContext result = this;
        for (DeploymentContext parent = this.getParent(); parent != null; parent = parent.getParent()) {
            result = parent;
        }
        return result;
    }

    @Override
    public ObjectName getTopLevelName() {
        DeploymentContext top = this.getTopLevel();
        if (top == null || !(top instanceof DeploymentMBean)) {
            return null;
        }
        return ((DeploymentMBean)((Object)top)).getObjectName();
    }

    @Override
    public DeploymentContext getParent() {
        return this.parent;
    }

    @Override
    public ObjectName getParentName() {
        DeploymentContext parent = this.getParent();
        if (parent == null || !(parent instanceof DeploymentMBean)) {
            return null;
        }
        return ((DeploymentMBean)((Object)parent)).getObjectName();
    }

    @Override
    public void setParent(DeploymentContext parent) {
        if (parent != null && this.parent != null) {
            throw new IllegalStateException("Context already has a parent " + this.getName());
        }
        this.parent = parent;
    }

    @Override
    public List<DeploymentContext> getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<DeploymentContext>(this.children);
    }

    @Override
    public List<ObjectName> getChildNames() {
        List<DeploymentContext> children = this.getChildren();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (DeploymentContext child : children) {
            if (!(child instanceof DeploymentMBean)) continue;
            result.add(((DeploymentMBean)((Object)child)).getObjectName());
        }
        return result;
    }

    @Override
    public void addChild(DeploymentContext child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        if (this.children == null) {
            this.children = new TreeSet<DeploymentContext>(this.comparator);
        }
        this.children.add(child);
        if (this.server != null) {
            this.registerMBeans(child, true, true);
        }
    }

    @Override
    public boolean removeChild(DeploymentContext child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        if (this.children == null) {
            return false;
        }
        if (this.server != null) {
            this.unregisterMBeans(child, true, true);
        }
        return this.children.remove(child);
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public List<DeploymentContext> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public List<ObjectName> getComponentNames() {
        List<DeploymentContext> components = this.getComponents();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (DeploymentContext component : components) {
            if (!(component instanceof DeploymentMBean)) continue;
            result.add(((DeploymentMBean)((Object)component)).getObjectName());
        }
        return result;
    }

    @Override
    public void addComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.deployed();
        this.components.add(component);
        if (this.server != null) {
            this.registerMBeans(component, true, true);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Added component " + component.getName() + " to " + this.getName()));
        }
    }

    @Override
    public boolean removeComponent(DeploymentContext component) {
        List<DeploymentContext> componentComponents;
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        if (this.server != null) {
            this.unregisterMBeans(component, true, true);
        }
        if (!(componentComponents = component.getComponents()).isEmpty()) {
            log.warn((Object)("Removing component " + this.name + " which still has components " + componentComponents));
        }
        boolean result = this.components.remove(component);
        component.cleanup();
        if (result && log.isTraceEnabled()) {
            log.trace((Object)("Removed component " + component.getName() + " from " + this.getName()));
        }
        return result;
    }

    @Override
    public ClassLoader getResourceClassLoader() {
        if (this.resourceClassLoader != null) {
            return this.resourceClassLoader;
        }
        DeploymentResourceLoader loader = this.getResourceLoader();
        this.resourceClassLoader = new DeploymentResourceClassLoader(loader);
        return this.resourceClassLoader;
    }

    @Override
    public DeploymentResourceLoader getResourceLoader() {
        return EmptyResourceLoader.INSTANCE;
    }

    @Override
    public Object getControllerContextName() {
        ControllerContext controllerContext = (ControllerContext)this.getTransientAttachments().getAttachment(ControllerContext.class);
        if (controllerContext != null) {
            return controllerContext.getName();
        }
        DeploymentContext parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Deployment ControllerContext has not been set");
        }
        return parent.getControllerContextName();
    }

    @Override
    public DeploymentStage getRequiredStage() {
        DeploymentContext parent = this.getParent();
        if (parent != null) {
            return parent.getRequiredStage();
        }
        return this.requiredStage;
    }

    @Override
    public void setRequiredStage(DeploymentStage stage) {
        DeploymentContext parent = this.getParent();
        if (parent != null) {
            parent.setRequiredStage(stage);
        } else {
            this.requiredStage = stage;
        }
    }

    @Override
    public DependencyInfo getDependencyInfo() {
        ControllerContext controllerContext = (ControllerContext)this.getTransientAttachments().getAttachment(ControllerContext.class);
        if (controllerContext != null) {
            return controllerContext.getDependencyInfo();
        }
        DeploymentContext parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Deployment ControllerContext has not been set");
        }
        return parent.getDependencyInfo();
    }

    public MutableAttachments getTransientAttachments() {
        return this.transientAttachments;
    }

    public MutableAttachments getTransientManagedObjects() {
        return this.transientManagedObjects;
    }

    @Override
    public String listAttachments(boolean detail) {
        HashSet<String> processed = new HashSet<String>();
        StringBuilder result = new StringBuilder();
        result.append("<table>");
        result.append("<tr><th>Attachment</th><th>Created</th><th>Referenced</th>");
        if (detail) {
            result.append("<th>Contents</th>");
        }
        result.append("<tr><td>Predetermined</td></tr>");
        AbstractDeploymentContext.listAttachments(result, this.getPredeterminedManagedObjects(), detail, processed);
        result.append("<tr><td>Managed Objects</td></tr>");
        AbstractDeploymentContext.listAttachments(result, (Attachments)this.getTransientManagedObjects(), detail, processed);
        result.append("<tr><td>Transient</td></tr>");
        AbstractDeploymentContext.listAttachments(result, (Attachments)this.getTransientAttachments(), detail, processed);
        result.append("</table>");
        return result.toString();
    }

    protected static void listAttachments(StringBuilder builder, Attachments attachments, boolean detail, Set<String> processed) {
        TrackingMutableAttachments tracking = null;
        if (attachments instanceof TrackingMutableAttachments) {
            tracking = (TrackingMutableAttachments)attachments;
        }
        for (Map.Entry attachment : attachments.getAttachments().entrySet()) {
            Set<String> deployers;
            String name = (String)attachment.getKey();
            List referenced = Collections.emptyList();
            if (tracking != null && (deployers = tracking.getReferenced(name)) != null) {
                referenced = new ArrayList<String>(tracking.getReferenced(name));
            }
            for (int row = 0; row < 1 || row < referenced.size(); ++row) {
                builder.append("<tr>");
                if (row == 0) {
                    builder.append("<td>`--").append(name).append("</td>");
                    if (tracking != null) {
                        builder.append("<td>").append(tracking.getCreated(name)).append("</td>");
                    } else {
                        builder.append("<td/>");
                    }
                } else {
                    builder.append("<td/><td/>");
                }
                if (tracking != null && row < referenced.size()) {
                    builder.append("<td>").append((String)referenced.get(row)).append("</td>");
                } else {
                    builder.append("<td/>");
                }
                if (row == 0 && detail) {
                    builder.append("<td>").append(attachment.getValue()).append("</td>");
                }
                builder.append("</tr>");
            }
            builder.append("</tr>");
        }
    }

    @Override
    public void visit(DeploymentContextVisitor visitor) throws DeploymentException {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visit(this, visitor);
    }

    private void visit(DeploymentContext context, DeploymentContextVisitor visitor) throws DeploymentException {
        visitor.visit(context);
        try {
            List<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            DeploymentContext[] childContexts = children.toArray(new DeploymentContext[children.size()]);
            for (int i = 0; i < childContexts.length; ++i) {
                if (childContexts[i] == null) {
                    throw new IllegalStateException("Null child context for " + context.getName() + " children=" + children);
                }
                try {
                    this.visit(childContexts[i], visitor);
                    continue;
                }
                catch (Throwable t) {
                    for (int j = i - 1; j >= 0; --j) {
                        this.visitError(childContexts[j], visitor, true);
                    }
                    throw DeploymentException.rethrowAsDeploymentException((String)("Error visiting: " + childContexts[i].getName()), (Throwable)t);
                }
            }
        }
        catch (Throwable t) {
            this.visitError(context, visitor, false);
            throw DeploymentException.rethrowAsDeploymentException((String)("Error visiting: " + context.getName()), (Throwable)t);
        }
    }

    private void visitError(DeploymentContext context, DeploymentContextVisitor visitor, boolean visitChildren) throws DeploymentException {
        if (visitChildren) {
            List<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            for (DeploymentContext child : children) {
                try {
                    this.visitError(child, visitor, true);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during visit error: " + child.getName()), t);
                }
            }
        }
        try {
            visitor.error(context);
        }
        catch (Throwable t) {
            log.warn((Object)("Error during visit error: " + context.getName()), t);
        }
    }

    @Override
    public Throwable getProblem() {
        return this.problem;
    }

    @Override
    public void setProblem(Throwable problem) {
        this.problem = problem;
    }

    @Override
    public boolean isDeployed() {
        return this.deployed;
    }

    @Override
    public void deployed() {
        this.deployed = true;
    }

    @Override
    public void cleanup() {
        AbstractDeploymentContext.cleanupRepository(this);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            this.registerMBeans(this, false, true);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        this.unregisterMBeans(this, false, true);
    }

    @Override
    public void postDeregister() {
    }

    protected void registerMBeans(DeploymentContext context, boolean registerContext, boolean registerSubDeployments) {
        if (registerContext && context instanceof DeploymentMBean) {
            try {
                DeploymentMBean depMBean = (DeploymentMBean)((Object)context);
                this.server.registerMBean(context, depMBean.getObjectName());
            }
            catch (Exception e) {
                log.warn((Object)("Unable to register deployment mbean " + context.getName()), (Throwable)e);
            }
        }
        if (registerSubDeployments) {
            List<DeploymentContext> children = context.getChildren();
            for (DeploymentContext child : children) {
                this.registerMBeans(child, true, false);
            }
            List<DeploymentContext> components = context.getComponents();
            for (DeploymentContext component : components) {
                this.registerMBeans(component, false, false);
            }
        }
    }

    protected void unregisterMBeans(DeploymentContext context, boolean unregisterContext, boolean unregisterSubDeployments) {
        block6: {
            if (unregisterContext && context instanceof DeploymentMBean) {
                try {
                    DeploymentMBean depMBean = (DeploymentMBean)((Object)context);
                    this.server.unregisterMBean(depMBean.getObjectName());
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block6;
                    log.trace((Object)("Unable to unregister deployment mbean " + context.getName()), (Throwable)e);
                }
            }
        }
        if (unregisterSubDeployments) {
            List<DeploymentContext> children = context.getChildren();
            for (DeploymentContext child : children) {
                this.unregisterMBeans(child, true, false);
            }
            List<DeploymentContext> components = context.getComponents();
            for (DeploymentContext component : components) {
                this.unregisterMBeans(component, false, false);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append('{').append(this.name).append('}');
        return buffer.toString();
    }

    protected DeploymentUnit createDeploymentUnit() {
        return new AbstractDeploymentUnit(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = in.readUTF();
        this.simpleName = in.readUTF();
        this.relativePath = in.readUTF();
        this.state = (DeploymentState)in.readObject();
        this.problem = (Throwable)in.readObject();
        this.deployment = (Deployment)in.readObject();
        this.deployed = in.readBoolean();
        this.parent = (DeploymentContext)in.readObject();
        this.deploymentTypes = (Set)in.readObject();
        this.children = (SortedSet)in.readObject();
        this.components = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.name);
        out.writeUTF(this.simpleName);
        out.writeUTF(this.relativePath);
        out.writeObject(this.state);
        out.writeObject(this.problem);
        out.writeObject(this.deployment);
        out.writeBoolean(this.deployed);
        out.writeObject(this.parent);
        out.writeObject(this.deploymentTypes);
        out.writeObject(this.children);
        out.writeObject(this.components);
    }
}

