/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.util.collection.WeakSet;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.MatchAllVirtualFileFilter;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final VirtualFileHandler handler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private transient Set<InputStream> streams;

    public VirtualFile(VirtualFileHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        this.handler = handler;
    }

    VirtualFileHandler getHandler() {
        if (this.closed.get()) {
            throw new IllegalStateException("The virtual file is closed");
        }
        return this.handler;
    }

    public String getName() {
        return this.getHandler().getName();
    }

    public String getPathName() {
        return this.getHandler().getPathName();
    }

    public URL toURL() throws MalformedURLException, URISyntaxException {
        return this.getHandler().toVfsUrl();
    }

    public URI toURI() throws MalformedURLException, URISyntaxException {
        return VFSUtils.toURI(this.toURL());
    }

    public long getLastModified() throws IOException {
        return this.getHandler().getLastModified();
    }

    public boolean hasBeenModified() throws IOException {
        return this.getHandler().hasBeenModified();
    }

    public long getSize() throws IOException {
        return this.getHandler().getSize();
    }

    public boolean exists() throws IOException {
        return this.getHandler().exists();
    }

    public boolean isLeaf() throws IOException {
        return this.getHandler().isLeaf();
    }

    public boolean isHidden() throws IOException {
        return this.getHandler().isHidden();
    }

    public InputStream openStream() throws IOException {
        InputStream result = this.getHandler().openStream();
        this.checkStreams();
        this.streams.add(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStreams() {
        if (this.streams == null) {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (this.streams == null) {
                    this.streams = Collections.synchronizedSet(new WeakSet());
                }
            }
        }
    }

    public void closeStreams() {
        if (this.streams == null) {
            return;
        }
        for (InputStream stream : this.streams) {
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        this.streams.clear();
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.closeStreams();
            this.handler.close();
        }
    }

    public VFS getVFS() {
        VFSContext context = this.getHandler().getVFSContext();
        return context.getVFS();
    }

    public VirtualFile getParent() throws IOException {
        VirtualFileHandler parent = this.getHandler().getParent();
        if (parent != null) {
            return parent.getVirtualFile();
        }
        return null;
    }

    public List<VirtualFile> getChildren() throws IOException {
        return this.getChildren(null);
    }

    public List<VirtualFile> getChildren(VirtualFileFilter filter) throws IOException {
        if (this.isLeaf()) {
            return Collections.emptyList();
        }
        if (filter == null) {
            filter = MatchAllVirtualFileFilter.INSTANCE;
        }
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, null);
        this.visit(visitor);
        return visitor.getMatched();
    }

    public List<VirtualFile> getChildrenRecursively() throws IOException {
        return this.getChildrenRecursively(null);
    }

    public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        if (this.isLeaf()) {
            return Collections.emptyList();
        }
        if (filter == null) {
            filter = MatchAllVirtualFileFilter.INSTANCE;
        }
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, VisitorAttributes.RECURSE);
        this.visit(visitor);
        return visitor.getMatched();
    }

    public void visit(VirtualFileVisitor visitor) throws IOException {
        if (!this.isLeaf()) {
            this.getVFS().visit(this, visitor);
        }
    }

    @Deprecated
    public VirtualFile findChild(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        VirtualFileHandler handler = this.getHandler();
        if (handler.isLeaf()) {
            throw new IllegalStateException("File cannot contain children: " + this);
        }
        VirtualFileHandler child = handler.getChild(VFSUtils.fixName(path));
        if (child == null) {
            List<VirtualFileHandler> children = handler.getChildren(true);
            throw new IOException("Child not found " + path + " for " + handler + ", available children: " + children);
        }
        return child.getVirtualFile();
    }

    public VirtualFile getChild(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        VirtualFileHandler handler = this.getHandler();
        VirtualFileHandler child = handler.getChild(VFSUtils.fixName(path));
        return child != null ? child.getVirtualFile() : null;
    }

    public String toString() {
        return this.handler.toString();
    }

    public int hashCode() {
        return this.handler.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VirtualFile)) {
            return false;
        }
        VirtualFile other = (VirtualFile)obj;
        return this.handler.equals(other.handler);
    }
}

