/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.plugins.context.zip.ZipWrapper;

abstract class ZipBytesWrapper
extends ZipWrapper {
    private byte[] zipBytes;
    private String name;

    ZipBytesWrapper(InputStream zipStream, String name, long lastModified) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipEntryContext.copyStreamAndClose(zipStream, bout);
        this.zipBytes = bout.toByteArray();
        this.name = name;
        this.lastModified = lastModified;
    }

    boolean exists() {
        return true;
    }

    long getLastModified() {
        return this.lastModified;
    }

    String getName() {
        return this.name;
    }

    long getSize() {
        return this.zipBytes.length;
    }

    InputStream getRootAsStream() throws FileNotFoundException {
        return new ByteArrayInputStream(this.zipBytes);
    }

    void acquire() {
    }

    void close() {
        this.zipBytes = null;
    }

    public String toString() {
        return super.toString() + " - " + this.name;
    }
}

