/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.copy.CopyMechanism;
import org.jboss.virtual.plugins.copy.ExplodedCopyMechanism;
import org.jboss.virtual.plugins.copy.TempCopyMechanism;
import org.jboss.virtual.plugins.copy.UnpackCopyMechanism;
import org.jboss.virtual.spi.LinkInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.cache.VFSCacheFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSUtils {
    private static final Logger log = Logger.getLogger(VFSUtils.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String VFS_LINK_INFIX = ".vfslink";
    public static final String VFS_LINK_PROPERTIES_SUFFIX = ".vfslink.properties";
    public static final String VFS_LINK_NAME = "vfs.link.name";
    public static final String VFS_LINK_TARGET = "vfs.link.target";
    public static final String FORCE_COPY_KEY = "jboss.vfs.forceCopy";
    public static final String USE_COPY_QUERY = "useCopyJarHandler";
    public static final String FORCE_VFS_JAR_KEY = "jboss.vfs.forceVfsJar";
    public static final String FORCE_NO_REAPER_KEY = "jboss.vfs.forceNoReaper";
    public static final String NO_REAPER_QUERY = "noReaper";
    public static final String FORCE_CASE_SENSITIVE_KEY = "jboss.vfs.forceCaseSensitive";
    public static final String CASE_SENSITIVE_QUERY = "caseSensitive";
    public static final String OPTIMIZE_FOR_MEMORY_KEY = "jboss.vfs.optimizeForMemory";
    public static final String VFS_CACHE_KEY = "jboss.vfs.cache";
    private static final ResourceCreator<URL> URL_CREATOR = new ResourceCreator<URL>(){

        @Override
        public URL getResource(VirtualFile file) throws Exception {
            return file.toURL();
        }

        @Override
        public String getString(URL resource) {
            return resource.toExternalForm();
        }

        @Override
        public URL createResource(String string) throws Exception {
            return new URL(string);
        }
    };
    private static final ResourceCreator<URI> URI_CREATOR = new ResourceCreator<URI>(){

        @Override
        public URI getResource(VirtualFile file) throws Exception {
            return file.toURI();
        }

        @Override
        public String getString(URI resource) {
            return resource.toString();
        }

        @Override
        public URI createResource(String string) throws Exception {
            return new URI(string);
        }
    };

    public static void stopCache() {
        VFSCacheFactory.getInstance().stop();
    }

    public static String getPathsString(Collection<VirtualFile> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Null paths");
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (VirtualFile path : paths) {
            if (path == null) {
                throw new IllegalArgumentException("Null path in " + paths);
            }
            if (!first) {
                buffer.append(':');
            } else {
                first = false;
            }
            buffer.append(path.getPathName());
        }
        if (first) {
            buffer.append("<empty>");
        }
        return buffer.toString();
    }

    public static void addManifestLocations(VirtualFile file, List<VirtualFile> paths) throws IOException {
        int rootPathLength;
        URL vfsRootURL;
        URL parentURL;
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Null paths");
        }
        Manifest manifest = VFSUtils.getManifest(file);
        if (manifest == null) {
            return;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        if (classPath == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Manifest has no Class-Path for " + file.getPathName()));
            }
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            log.debug((Object)(file + " has no parent."));
            return;
        }
        try {
            parentURL = parent.toURL();
            vfsRootURL = file.getVFS().getRoot().toURL();
            rootPathLength = vfsRootURL.getPath().length();
        }
        catch (URISyntaxException e) {
            log.debug((Object)("Failed to get parent URL for " + file + ", reason=" + e));
            return;
        }
        String parentPath = parentURL.toString();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                URL libURL = new URL(parentPath + path);
                String libPath = libURL.getPath();
                if (rootPathLength > libPath.length()) {
                    log.debug((Object)("Invalid rootPath: " + vfsRootURL + ", libPath: " + libPath));
                    continue;
                }
                String vfsLibPath = libPath.substring(rootPathLength);
                VirtualFile vf = file.getVFS().getChild(vfsLibPath);
                if (vf == null || paths.contains(vf)) continue;
                paths.add(vf);
                VFSUtils.addManifestLocations(vf, paths);
            }
            catch (IOException e) {
                log.debug((Object)("Manifest Class-Path entry " + path + " ignored for " + file.getPathName() + " reason=" + e));
            }
        }
    }

    public static Manifest getManifest(VirtualFile archive) throws IOException {
        if (archive == null) {
            throw new IllegalArgumentException("Null archive");
        }
        VirtualFile manifest = archive.getChild("META-INF/MANIFEST.MF");
        if (manifest == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Can't find manifest for " + archive.getPathName()));
            }
            return null;
        }
        return VFSUtils.readManifest(manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest readManifest(VirtualFile manifest) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("Null manifest file");
        }
        InputStream stream = manifest.openStream();
        try {
            Manifest manifest2 = new Manifest(stream);
            return manifest2;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Manifest getManifest(VFS archive) throws IOException {
        if (archive == null) {
            throw new IllegalArgumentException("Null vfs archive");
        }
        VirtualFile root = archive.getRoot();
        return VFSUtils.getManifest(root);
    }

    public static String fixName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        int length = name.length();
        if (length <= 1) {
            return name;
        }
        if (name.charAt(length - 1) == '/') {
            return name.substring(0, length - 1);
        }
        return name;
    }

    public static String decode(String path) {
        return VFSUtils.decode(path, DEFAULT_ENCODING);
    }

    public static String decode(String path, String encoding) {
        try {
            return URLDecoder.decode(path, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot decode: " + path + " [" + encoding + "]", e);
        }
    }

    public static String getName(URI uri) {
        int lastSlash;
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        String name = uri.getPath();
        if (name != null && (lastSlash = name.lastIndexOf(47)) > 0) {
            name = name.substring(lastSlash + 1);
        }
        return name;
    }

    public static Map<String, String> parseURLQuery(String query) {
        Map pairsMap = CollectionsFactory.createLazyMap();
        if (query != null) {
            StringTokenizer tokenizer = new StringTokenizer(query, "=&");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                pairsMap.put(name, value);
            }
        }
        return pairsMap;
    }

    public static boolean isLink(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return name.indexOf(VFS_LINK_INFIX) >= 0;
    }

    public static List<LinkInfo> readLinkInfo(InputStream is, String name, Properties props) throws IOException, URISyntaxException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (name.endsWith(VFS_LINK_PROPERTIES_SUFFIX)) {
            ArrayList<LinkInfo> info = new ArrayList<LinkInfo>();
            VFSUtils.parseLinkProperties(is, info, props);
            return info;
        }
        throw new UnsupportedEncodingException("Unknown link format: " + name);
    }

    public static void parseLinkProperties(InputStream is, List<LinkInfo> info, Properties props) throws IOException, URISyntaxException {
        if (is == null) {
            throw new IllegalArgumentException("Null input stream");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null info");
        }
        if (props == null) {
            throw new IllegalArgumentException("Null properties");
        }
        props.load(is);
        int n = 0;
        while (true) {
            String nameKey = "vfs.link.name." + n;
            String name = props.getProperty(nameKey);
            String uriKey = "vfs.link.target." + n;
            String uri = props.getProperty(uriKey);
            if (uri == null) break;
            uri = StringPropertyReplacer.replaceProperties((String)uri);
            LinkInfo link = new LinkInfo(name, new URI(uri));
            info.add(link);
            ++n;
        }
    }

    public static URI toURI(URL url) throws URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            String urispec = url.toExternalForm();
            urispec = urispec.replaceAll("%", "%25");
            urispec = urispec.replaceAll(" ", "%20");
            return new URI(urispec);
        }
    }

    public static URL sanitizeURL(URL url) throws URISyntaxException, MalformedURLException {
        return VFSUtils.toURI(url).toURL();
    }

    private static Map<String, String> getOptions(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        VirtualFileHandler handler = file.getHandler();
        VFSContext context = handler.getVFSContext();
        return context.getOptions();
    }

    public static String getOption(VirtualFile file, String key) {
        Map<String, String> options = VFSUtils.getOptions(file);
        return options != null ? options.get(key) : null;
    }

    protected static void enableOption(VirtualFile file, String optionName) {
        Map<String, String> options = VFSUtils.getOptions(file);
        if (options == null) {
            throw new IllegalArgumentException("Cannot enable " + optionName + " on null options: " + file);
        }
        options.put(optionName, Boolean.TRUE.toString());
    }

    protected static void disableOption(VirtualFile file, String optionName) {
        Map<String, String> options = VFSUtils.getOptions(file);
        if (options == null) {
            throw new IllegalArgumentException("Cannot disable " + optionName + " on null options: " + file);
        }
        options.remove(optionName);
    }

    public static void enableCopy(VirtualFile file) {
        VFSUtils.enableOption(file, USE_COPY_QUERY);
    }

    public static void disableCopy(VirtualFile file) {
        VFSUtils.disableOption(file, USE_COPY_QUERY);
    }

    public static void enableNoReaper(VirtualFile file) {
        VFSUtils.enableOption(file, NO_REAPER_QUERY);
    }

    public static void disableNoReaper(VirtualFile file) {
        VFSUtils.disableOption(file, NO_REAPER_QUERY);
    }

    public static void enableCaseSensitive(VirtualFile file) {
        VFSUtils.enableOption(file, CASE_SENSITIVE_QUERY);
    }

    public static void disableCaseSensitive(VirtualFile file) {
        VFSUtils.disableOption(file, CASE_SENSITIVE_QUERY);
    }

    public static VirtualFile unpack(VirtualFile file) throws IOException, URISyntaxException {
        return VFSUtils.copy(file, UnpackCopyMechanism.INSTANCE);
    }

    public static VirtualFile explode(VirtualFile file) throws IOException, URISyntaxException {
        return VFSUtils.copy(file, ExplodedCopyMechanism.INSTANCE);
    }

    public static VirtualFile temp(VirtualFile file) throws IOException, URISyntaxException {
        return VFSUtils.copy(file, TempCopyMechanism.INSTANCE);
    }

    protected static VirtualFile copy(VirtualFile file, CopyMechanism mechanism) throws IOException, URISyntaxException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (mechanism == null) {
            throw new IllegalArgumentException("Null copy mechanism");
        }
        return mechanism.copy(file, file.getHandler());
    }

    public static boolean isNestedFile(VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        VirtualFileHandler handler = file.getHandler();
        return handler.isNested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamAndClose(InputStream is, OutputStream os) throws IOException {
        try {
            VFSUtils.copyStream(is, os);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        if (os == null) {
            throw new IllegalArgumentException("output stream is null");
        }
        try {
            byte[] buff = new byte[65536];
            int rc = is.read(buff);
            while (rc != -1) {
                os.write(buff, 0, rc);
                rc = is.read(buff);
            }
        }
        finally {
            os.flush();
        }
    }

    public static URL getCompatibleURL(VirtualFile file) throws Exception {
        return VFSUtils.getCompatibleResource(file, URL_CREATOR);
    }

    public static URI getCompatibleURI(VirtualFile file) throws Exception {
        return VFSUtils.getCompatibleResource(file, URI_CREATOR);
    }

    private static <T> T getCompatibleResource(VirtualFile file, ResourceCreator<T> creator) throws Exception {
        String uriString;
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (creator == null) {
            throw new IllegalArgumentException("Null creator");
        }
        T resource = creator.getResource(file);
        if (resource == null) {
            throw new IllegalArgumentException("Null resource: " + file);
        }
        if (!VFSUtils.isNestedFile(file) && (uriString = creator.getString(resource)).startsWith("vfs")) {
            resource = uriString.startsWith("vfszip") ? creator.createResource("file" + uriString.substring(6)) : creator.createResource(uriString.substring(3));
        }
        return resource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ResourceCreator<T> {
        public T getResource(VirtualFile var1) throws Exception;

        public String getString(T var1);

        public T createResource(String var1) throws Exception;
    }
}

