/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.util.Map;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;
import org.jboss.virtual.plugins.cache.CachePolicyVFSCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedVFSCache
extends CachePolicyVFSCache {
    private Integer defaultLifetime;
    private Boolean threadSafe;
    private Integer resolution;
    private String info;

    public TimedVFSCache() {
    }

    public TimedVFSCache(Integer defaultLifetime) {
        this(defaultLifetime, null, null);
    }

    public TimedVFSCache(Integer defaultLifetime, Boolean threadSafe, Integer resolution) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
        this.resolution = resolution;
    }

    public TimedVFSCache(Map<Object, Object> properties) {
        super(properties);
    }

    @Override
    protected CachePolicy createCachePolicy() {
        if (this.defaultLifetime == null) {
            this.defaultLifetime = TimedVFSCache.getInteger(this.readInstanceProperties("jboss.vfs.cache.TimedPolicyCaching.lifetime", null, true));
        }
        if (this.threadSafe == null) {
            this.threadSafe = Boolean.valueOf(this.readInstanceProperties("jboss.vfs.cache.TimedPolicyCaching.threadSafe", Boolean.TRUE, true).toString());
        }
        if (this.resolution == null) {
            this.resolution = TimedVFSCache.getInteger(this.readInstanceProperties("jboss.vfs.cache.TimedPolicyCaching.resolution", null, true));
        }
        this.log.debug((Object)("Creating timed cache policy, lifetime: " + this.defaultLifetime + ", threadSafe: " + this.threadSafe + ", resolution: " + this.resolution));
        TimedCachePolicy tcp = this.defaultLifetime == null ? new TimedCachePolicy() : (this.resolution != null ? new TimedCachePolicy(this.defaultLifetime.intValue(), this.threadSafe.booleanValue(), this.resolution.intValue()) : new TimedCachePolicy(this.defaultLifetime.intValue()));
        this.info = "TimedVFSCache{lifetime=" + tcp.getDefaultLifetime() + ", resolution=" + tcp.getResolution() + "}";
        return tcp;
    }

    public void setDefaultLifetime(Integer defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public void setThreadSafe(Boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    public String toString() {
        return this.info;
    }
}

