/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.virtual.plugins.context.zip.ZipBytesWrapper;
import org.jboss.virtual.plugins.context.zip.ZipEntryInfo;
import org.jboss.virtual.plugins.context.zip.ZipWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipDirWrapper
extends ZipBytesWrapper {
    private ByteArrayInputStream zisCopy;

    ZipDirWrapper(InputStream zipStream, String name, long lastModified, ByteArrayInputStream zisCopy) throws IOException {
        super(zipStream, name, lastModified);
        this.zisCopy = zisCopy;
    }

    @Override
    InputStream openStream(ZipEntryInfo info) throws IOException {
        this.zisCopy.reset();
        ZipInputStream zis = new ZipInputStream(this.zisCopy);
        ZipEntry entry = zis.getNextEntry();
        while (entry != null && !entry.getName().equals(info.getName())) {
            entry = zis.getNextEntry();
        }
        return zis;
    }

    @Override
    Enumeration<? extends ZipEntry> entries() throws IOException {
        this.zisCopy.reset();
        return new DirEnumeration();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirEnumeration
    implements Enumeration<ZipEntry> {
        private ZipInputStream zis;
        private ZipEntry entry;

        private DirEnumeration() {
            this.zis = new ZipInputStream(ZipDirWrapper.this.zisCopy);
        }

        @Override
        public boolean hasMoreElements() {
            try {
                this.entry = this.zis.getNextEntry();
                while (this.entry != null && !this.entry.getName().startsWith(ZipDirWrapper.this.getName())) {
                    this.entry = this.zis.getNextEntry();
                }
                return this.entry != null;
            }
            catch (IOException e) {
                ZipWrapper.log.warn((Object)("Error retrieving entries for entry " + ZipDirWrapper.this.getName() + ", cause: " + e));
                return false;
            }
        }

        @Override
        public ZipEntry nextElement() {
            return this.entry;
        }
    }
}

